/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp.agg;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.ArrayUtils;

public class Accumulators {
    public static Supplier<Accumulator> accumulatorFactory(AggregateCall call) {
        if (!call.isDistinct()) {
            return Accumulators.accumulatorFunctionFactory(call);
        }
        Supplier<Accumulator> fac = Accumulators.accumulatorFunctionFactory(call);
        return () -> new DistinctAccumulator(fac);
    }

    public static Supplier<Accumulator> accumulatorFunctionFactory(AggregateCall call) {
        switch (call.getAggregation().getName()) {
            case "COUNT": {
                return LongCount.FACTORY;
            }
            case "AVG": {
                return Accumulators.avgFactory(call);
            }
            case "SUM": {
                return Accumulators.sumFactory(call);
            }
            case "$SUM0": {
                return Accumulators.sumEmptyIsZeroFactory(call);
            }
            case "MIN": {
                return Accumulators.minFactory(call);
            }
            case "MAX": {
                return Accumulators.maxFactory(call);
            }
            case "SINGLE_VALUE": {
                return SingleVal.FACTORY;
            }
            case "ANY_VALUE": {
                return AnyVal.FACTORY;
            }
        }
        throw new AssertionError((Object)call.getAggregation().getName());
    }

    private static Supplier<Accumulator> avgFactory(AggregateCall call) {
        switch (call.type.getSqlTypeName()) {
            case BIGINT: 
            case DECIMAL: {
                return DecimalAvg.FACTORY;
            }
        }
        return DoubleAvg.FACTORY;
    }

    private static Supplier<Accumulator> sumFactory(AggregateCall call) {
        switch (call.type.getSqlTypeName()) {
            case BIGINT: 
            case DECIMAL: {
                return () -> new Sum(new DecimalSumEmptyIsZero());
            }
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return () -> new Sum(new DoubleSumEmptyIsZero());
            }
        }
        return () -> new Sum(new LongSumEmptyIsZero());
    }

    private static Supplier<Accumulator> sumEmptyIsZeroFactory(AggregateCall call) {
        switch (call.type.getSqlTypeName()) {
            case BIGINT: 
            case DECIMAL: {
                return DecimalSumEmptyIsZero.FACTORY;
            }
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return DoubleSumEmptyIsZero.FACTORY;
            }
        }
        return LongSumEmptyIsZero.FACTORY;
    }

    private static Supplier<Accumulator> minFactory(AggregateCall call) {
        switch (call.type.getSqlTypeName()) {
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return DoubleMinMax.MIN_FACTORY;
            }
            case DECIMAL: {
                return DecimalMinMax.MIN_FACTORY;
            }
            case INTEGER: {
                return IntMinMax.MIN_FACTORY;
            }
            case CHAR: 
            case VARCHAR: {
                return VarCharMinMax.MIN_FACTORY;
            }
        }
        return LongMinMax.MIN_FACTORY;
    }

    private static Supplier<Accumulator> maxFactory(AggregateCall call) {
        switch (call.type.getSqlTypeName()) {
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return DoubleMinMax.MAX_FACTORY;
            }
            case DECIMAL: {
                return DecimalMinMax.MAX_FACTORY;
            }
            case INTEGER: {
                return IntMinMax.MAX_FACTORY;
            }
            case CHAR: 
            case VARCHAR: {
                return VarCharMinMax.MAX_FACTORY;
            }
        }
        return LongMinMax.MAX_FACTORY;
    }

    private static class DistinctAccumulator
    implements Accumulator {
        private final Accumulator acc;
        private final Set<Object> set = new HashSet<Object>();

        private DistinctAccumulator(Supplier<Accumulator> accSup) {
            this.acc = accSup.get();
        }

        @Override
        public void add(Object ... args) {
            Object in = args[0];
            if (in == null) {
                return;
            }
            this.set.add(in);
        }

        @Override
        public void apply(Accumulator other) {
            DistinctAccumulator other0 = (DistinctAccumulator)other;
            this.set.addAll(other0.set);
        }

        @Override
        public Object end() {
            for (Object o : this.set) {
                this.acc.add(o);
            }
            return this.acc.end();
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return this.acc.argumentTypes(typeFactory);
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return this.acc.returnType(typeFactory);
        }
    }

    private static class DecimalMinMax
    implements Accumulator {
        public static final Supplier<Accumulator> MIN_FACTORY = () -> new DecimalMinMax(true);
        public static final Supplier<Accumulator> MAX_FACTORY = () -> new DecimalMinMax(false);
        private final boolean min;
        private BigDecimal val;

        private DecimalMinMax(boolean min) {
            this.min = min;
        }

        @Override
        public void add(Object ... args) {
            BigDecimal in = (BigDecimal)args[0];
            if (in == null) {
                return;
            }
            this.val = this.val == null ? in : (this.min ? this.val.min(in) : this.val.max(in));
        }

        @Override
        public void apply(Accumulator other) {
            DecimalMinMax other0 = (DecimalMinMax)other;
            if (other0.val == null) {
                return;
            }
            this.val = this.val == null ? other0.val : (this.min ? this.val.min(other0.val) : this.val.max(other0.val));
        }

        @Override
        public Object end() {
            return this.val;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true);
        }
    }

    private static class LongMinMax
    implements Accumulator {
        public static final Supplier<Accumulator> MIN_FACTORY = () -> new LongMinMax(true);
        public static final Supplier<Accumulator> MAX_FACTORY = () -> new LongMinMax(false);
        private final boolean min;
        private long val;
        private boolean empty = true;

        private LongMinMax(boolean min) {
            this.min = min;
        }

        @Override
        public void add(Object ... args) {
            Long in = (Long)args[0];
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? Math.min(this.val, in) : Math.max(this.val, in));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator other) {
            LongMinMax other0 = (LongMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? Math.min(this.val, other0.val) : Math.max(this.val, other0.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : Long.valueOf(this.val);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true);
        }
    }

    private static class IntMinMax
    implements Accumulator {
        public static final Supplier<Accumulator> MIN_FACTORY = () -> new IntMinMax(true);
        public static final Supplier<Accumulator> MAX_FACTORY = () -> new IntMinMax(false);
        private final boolean min;
        private int val;
        private boolean empty = true;

        private IntMinMax(boolean min) {
            this.min = min;
        }

        @Override
        public void add(Object ... args) {
            Integer in = (Integer)args[0];
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? Math.min(this.val, in) : Math.max(this.val, in));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator other) {
            IntMinMax other0 = (IntMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? Math.min(this.val, other0.val) : Math.max(this.val, other0.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : Integer.valueOf(this.val);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true);
        }
    }

    private static class VarCharMinMax
    implements Accumulator {
        public static final Supplier<Accumulator> MIN_FACTORY = () -> new VarCharMinMax(true);
        public static final Supplier<Accumulator> MAX_FACTORY = () -> new VarCharMinMax(false);
        private final boolean min;
        private CharSequence val;
        private boolean empty = true;

        private VarCharMinMax(boolean min) {
            this.min = min;
        }

        @Override
        public void add(Object ... args) {
            CharSequence in = (CharSequence)args[0];
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? (CharSeqComparator.INSTANCE.compare(this.val, in) < 0 ? this.val : in) : (CharSeqComparator.INSTANCE.compare(this.val, in) < 0 ? in : this.val));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator other) {
            VarCharMinMax other0 = (VarCharMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? (CharSeqComparator.INSTANCE.compare(this.val, other0.val) < 0 ? this.val : other0.val) : (CharSeqComparator.INSTANCE.compare(this.val, other0.val) < 0 ? other0.val : this.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : this.val;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
        }

        private static class CharSeqComparator
        implements Comparator<CharSequence> {
            private static final CharSeqComparator INSTANCE = new CharSeqComparator();

            private CharSeqComparator() {
            }

            @Override
            public int compare(CharSequence s1, CharSequence s2) {
                int len = Math.min(s1.length(), s2.length());
                for (int i = 0; i < len; ++i) {
                    int cmp = Character.compare(s1.charAt(i), s2.charAt(i));
                    if (cmp == 0) continue;
                    return cmp;
                }
                return Integer.compare(s1.length(), s2.length());
            }
        }
    }

    private static class DoubleMinMax
    implements Accumulator {
        public static final Supplier<Accumulator> MIN_FACTORY = () -> new DoubleMinMax(true);
        public static final Supplier<Accumulator> MAX_FACTORY = () -> new DoubleMinMax(false);
        private final boolean min;
        private double val;
        private boolean empty = true;

        private DoubleMinMax(boolean min) {
            this.min = min;
        }

        @Override
        public void add(Object ... args) {
            Double in = (Double)args[0];
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? Math.min(this.val, in) : Math.max(this.val, in));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator other) {
            DoubleMinMax other0 = (DoubleMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? Math.min(this.val, other0.val) : Math.max(this.val, other0.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : Double.valueOf(this.val);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true);
        }
    }

    private static class DecimalSumEmptyIsZero
    implements Accumulator {
        public static final Supplier<Accumulator> FACTORY = DecimalSumEmptyIsZero::new;
        private BigDecimal sum;

        private DecimalSumEmptyIsZero() {
        }

        @Override
        public void add(Object ... args) {
            BigDecimal in = (BigDecimal)args[0];
            if (in == null) {
                return;
            }
            this.sum = this.sum == null ? in : this.sum.add(in);
        }

        @Override
        public void apply(Accumulator other) {
            DecimalSumEmptyIsZero other0 = (DecimalSumEmptyIsZero)other;
            this.sum = this.sum == null ? other0.sum : this.sum.add(other0.sum);
        }

        @Override
        public Object end() {
            return this.sum != null ? this.sum : BigDecimal.ZERO;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true);
        }
    }

    private static class LongSumEmptyIsZero
    implements Accumulator {
        public static final Supplier<Accumulator> FACTORY = LongSumEmptyIsZero::new;
        private long sum;

        private LongSumEmptyIsZero() {
        }

        @Override
        public void add(Object ... args) {
            Long in = (Long)args[0];
            if (in == null) {
                return;
            }
            this.sum += in.longValue();
        }

        @Override
        public void apply(Accumulator other) {
            LongSumEmptyIsZero other0 = (LongSumEmptyIsZero)other;
            this.sum += other0.sum;
        }

        @Override
        public Object end() {
            return this.sum;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true);
        }
    }

    private static class IntSumEmptyIsZero
    implements Accumulator {
        public static final Supplier<Accumulator> FACTORY = IntSumEmptyIsZero::new;
        private int sum;

        private IntSumEmptyIsZero() {
        }

        @Override
        public void add(Object ... args) {
            Integer in = (Integer)args[0];
            if (in == null) {
                return;
            }
            this.sum += in.intValue();
        }

        @Override
        public void apply(Accumulator other) {
            IntSumEmptyIsZero other0 = (IntSumEmptyIsZero)other;
            this.sum += other0.sum;
        }

        @Override
        public Object end() {
            return this.sum;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true);
        }
    }

    private static class DoubleSumEmptyIsZero
    implements Accumulator {
        public static final Supplier<Accumulator> FACTORY = DoubleSumEmptyIsZero::new;
        private double sum;

        private DoubleSumEmptyIsZero() {
        }

        @Override
        public void add(Object ... args) {
            Double in = (Double)args[0];
            if (in == null) {
                return;
            }
            this.sum += in.doubleValue();
        }

        @Override
        public void apply(Accumulator other) {
            DoubleSumEmptyIsZero other0 = (DoubleSumEmptyIsZero)other;
            this.sum += other0.sum;
        }

        @Override
        public Object end() {
            return this.sum;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true);
        }
    }

    private static class Sum
    implements Accumulator {
        private Accumulator acc;
        private boolean empty = true;

        public Sum(Accumulator acc) {
            this.acc = acc;
        }

        @Override
        public void add(Object ... args) {
            if (args[0] == null) {
                return;
            }
            this.empty = false;
            this.acc.add(args[0]);
        }

        @Override
        public void apply(Accumulator other) {
            Sum other0 = (Sum)other;
            if (other0.empty) {
                return;
            }
            this.empty = false;
            this.acc.apply(other0.acc);
        }

        @Override
        public Object end() {
            return this.empty ? null : this.acc.end();
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return this.acc.argumentTypes(typeFactory);
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return this.acc.returnType(typeFactory);
        }
    }

    private static class LongCount
    implements Accumulator {
        public static final Supplier<Accumulator> FACTORY = LongCount::new;
        private long cnt;

        private LongCount() {
        }

        @Override
        public void add(Object ... args) {
            assert (ArrayUtils.nullOrEmpty((Object[])args) || args.length == 1);
            if (ArrayUtils.nullOrEmpty((Object[])args) || args[0] != null) {
                ++this.cnt;
            }
        }

        @Override
        public void apply(Accumulator other) {
            LongCount other0 = (LongCount)other;
            this.cnt += other0.cnt;
        }

        @Override
        public Object end() {
            return this.cnt;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), false));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public static class DoubleAvg
    implements Accumulator {
        public static final Supplier<Accumulator> FACTORY = DoubleAvg::new;
        private double sum;
        private long cnt;

        @Override
        public void add(Object ... args) {
            Double in = (Double)args[0];
            if (in == null) {
                return;
            }
            this.sum += in.doubleValue();
            ++this.cnt;
        }

        @Override
        public void apply(Accumulator other) {
            DoubleAvg other0 = (DoubleAvg)other;
            this.sum += other0.sum;
            this.cnt += other0.cnt;
        }

        @Override
        public Object end() {
            return this.cnt > 0L ? Double.valueOf(this.sum / (double)this.cnt) : null;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true);
        }
    }

    public static class DecimalAvg
    implements Accumulator {
        public static final Supplier<Accumulator> FACTORY = DecimalAvg::new;
        private BigDecimal sum = BigDecimal.ZERO;
        private BigDecimal cnt = BigDecimal.ZERO;

        @Override
        public void add(Object ... args) {
            BigDecimal in = (BigDecimal)args[0];
            if (in == null) {
                return;
            }
            this.sum = this.sum.add(in);
            this.cnt = this.cnt.add(BigDecimal.ONE);
        }

        @Override
        public void apply(Accumulator other) {
            DecimalAvg other0 = (DecimalAvg)other;
            this.sum = this.sum.add(other0.sum);
            this.cnt = this.cnt.add(other0.cnt);
        }

        @Override
        public Object end() {
            return this.cnt.compareTo(BigDecimal.ZERO) == 0 ? null : this.sum.divide(this.cnt, MathContext.DECIMAL64);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true);
        }
    }

    private static class AnyVal
    implements Accumulator {
        private Object holder;
        public static final Supplier<Accumulator> FACTORY = AnyVal::new;

        private AnyVal() {
        }

        @Override
        public void add(Object ... args) {
            assert (args.length == 1) : args.length;
            if (this.holder == null) {
                this.holder = args[0];
            }
        }

        @Override
        public void apply(Accumulator other) {
            if (this.holder == null) {
                this.holder = ((AnyVal)other).holder;
            }
        }

        @Override
        public Object end() {
            return this.holder;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return List.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createSqlType(SqlTypeName.ANY);
        }
    }

    private static class SingleVal
    extends AnyVal {
        private boolean touched;
        public static final Supplier<Accumulator> FACTORY = SingleVal::new;

        private SingleVal() {
        }

        @Override
        public void add(Object ... args) {
            if (this.touched) {
                throw new IllegalArgumentException("Subquery returned more than 1 value.");
            }
            this.touched = true;
            super.add(args);
        }

        @Override
        public void apply(Accumulator other) {
            if (((SingleVal)other).touched) {
                if (this.touched) {
                    throw new IllegalArgumentException("Subquery returned more than 1 value.");
                }
                this.touched = true;
            }
            super.apply(other);
        }
    }
}

