/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.sql.engine.metadata.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteIntList;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.NotNull;

public class ColocationGroup
implements Serializable {
    private static final int SYNTHETIC_PARTITIONS_COUNT = 512;
    private List<Long> sourceIds;
    private List<String> nodeIds;
    private List<List<String>> assignments;

    public static ColocationGroup forNodes(List<String> nodeIds) {
        return new ColocationGroup(null, nodeIds, null);
    }

    public static ColocationGroup forAssignments(List<List<String>> assignments) {
        return new ColocationGroup(null, null, assignments);
    }

    public static ColocationGroup forSourceId(long sourceId) {
        return new ColocationGroup(Collections.singletonList(sourceId), null, null);
    }

    private ColocationGroup(List<Long> sourceIds, List<String> nodeIds, List<List<String>> assignments) {
        this.sourceIds = sourceIds;
        this.nodeIds = nodeIds;
        this.assignments = assignments;
    }

    public List<Long> sourceIds() {
        return this.sourceIds == null ? Collections.emptyList() : this.sourceIds;
    }

    public List<String> nodeIds() {
        return this.nodeIds == null ? Collections.emptyList() : this.nodeIds;
    }

    public List<List<String>> assignments() {
        return this.assignments == null ? Collections.emptyList() : this.assignments;
    }

    public ColocationGroup prune(IgniteRel rel) {
        return this;
    }

    public boolean belongs(long sourceId) {
        return this.sourceIds != null && this.sourceIds.contains(sourceId);
    }

    public ColocationGroup colocate(ColocationGroup other) throws ColocationMappingException {
        List<List<String>> assignments;
        List sourceIds = this.sourceIds == null || other.sourceIds == null ? (List)IgniteUtils.firstNotNull((Object[])new List[]{this.sourceIds, other.sourceIds}) : Commons.combine(this.sourceIds, other.sourceIds);
        List nodeIds = this.nodeIds == null || other.nodeIds == null ? (List)IgniteUtils.firstNotNull((Object[])new List[]{this.nodeIds, other.nodeIds}) : Commons.intersect(other.nodeIds, this.nodeIds);
        if (nodeIds != null && nodeIds.isEmpty()) {
            throw new ColocationMappingException("Failed to map fragment to location. Replicated query parts are not co-located on all nodes");
        }
        if (this.assignments == null || other.assignments == null) {
            assignments = (List)IgniteUtils.firstNotNull((Object[])new List[]{this.assignments, other.assignments});
            if (assignments != null && nodeIds != null) {
                HashSet filter = new HashSet(nodeIds);
                ArrayList assignments0 = new ArrayList(assignments.size());
                for (int i = 0; i < assignments.size(); ++i) {
                    List assignment = Commons.intersect(filter, (List)assignments.get(i));
                    if (assignment.isEmpty()) {
                        throw new ColocationMappingException("Failed to map fragment to location. Partition mapping is empty [part=" + i + "]");
                    }
                    assignments0.add(assignment);
                }
                assignments = assignments0;
            }
        } else {
            assert (this.assignments.size() == other.assignments.size());
            assignments = new ArrayList(this.assignments.size());
            HashSet filter = nodeIds == null ? null : new HashSet(nodeIds);
            for (int i = 0; i < this.assignments.size(); ++i) {
                List<String> assignment = Commons.intersect(this.assignments.get(i), other.assignments.get(i));
                if (filter != null) {
                    assignment.retainAll(filter);
                }
                if (assignment.isEmpty()) {
                    throw new ColocationMappingException("Failed to map fragment to location. Partition mapping is empty [part=" + i + "]");
                }
                assignments.add(assignment);
            }
        }
        return new ColocationGroup(sourceIds, nodeIds, assignments);
    }

    public ColocationGroup finalaze() {
        if (this.assignments == null && this.nodeIds == null) {
            return this;
        }
        if (this.assignments != null) {
            ArrayList<List<String>> assignments = new ArrayList<List<String>>(this.assignments.size());
            HashSet<String> nodes = new HashSet<String>();
            for (List<String> assignment : this.assignments) {
                String first = (String)CollectionUtils.first(assignment);
                if (first != null) {
                    nodes.add(first);
                }
                assignments.add(first != null ? Collections.singletonList(first) : Collections.emptyList());
            }
            return new ColocationGroup(this.sourceIds, new ArrayList<String>(nodes), assignments);
        }
        return this.forNodes0(this.nodeIds);
    }

    public ColocationGroup mapToNodes(List<String> nodeIds) {
        return !CollectionUtils.nullOrEmpty(this.nodeIds) ? this : this.forNodes0(nodeIds);
    }

    @NotNull
    private ColocationGroup forNodes0(List<String> nodeIds) {
        ArrayList<List<String>> assignments = new ArrayList<List<String>>(512);
        for (int i = 0; i < 512; ++i) {
            assignments.add(ArrayUtils.asList((Object[])new String[]{nodeIds.get(i % nodeIds.size())}));
        }
        return new ColocationGroup(this.sourceIds, nodeIds, assignments);
    }

    public int[] partitions(String nodeId) {
        IgniteIntList parts = new IgniteIntList(this.assignments.size());
        for (int i = 0; i < this.assignments.size(); ++i) {
            List<String> assignment = this.assignments.get(i);
            if (!Objects.equals(nodeId, CollectionUtils.first(assignment))) continue;
            parts.add(i);
        }
        return parts.array();
    }
}

