/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.metadata.FragmentMapping;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMetadata;
import org.apache.ignite.internal.sql.engine.prepare.MappingQueryContext;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.util.IgniteUtils;

public class RelMetadataQueryEx
extends RelMetadataQuery {
    private static final IgniteMetadata.FragmentMappingMetadata.Handler SOURCE_DISTRIBUTION_INITIAL_HANDLER;
    private IgniteMetadata.FragmentMappingMetadata.Handler sourceDistributionHandler = SOURCE_DISTRIBUTION_INITIAL_HANDLER;

    public static RelMetadataQueryEx create() {
        return RelMetadataQueryEx.create(IgniteMetadata.METADATA_PROVIDER);
    }

    public static RelMetadataQueryEx create(RelMetadataProvider metadataProvider) {
        THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)metadataProvider));
        try {
            RelMetadataQueryEx relMetadataQueryEx = new RelMetadataQueryEx();
            return relMetadataQueryEx;
        }
        finally {
            THREAD_PROVIDERS.remove();
        }
    }

    private RelMetadataQueryEx() {
    }

    public FragmentMapping fragmentMapping(RelNode rel, MappingQueryContext ctx) {
        while (true) {
            try {
                return this.sourceDistributionHandler.fragmentMapping(rel, this, ctx);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.sourceDistributionHandler = (IgniteMetadata.FragmentMappingMetadata.Handler)this.revise(e.relClass, IgniteMetadata.FragmentMappingMetadata.DEF);
                continue;
            }
            break;
        }
    }

    static {
        try (ScanResult scanResult = new ClassGraph().acceptPackages(new String[]{"org.apache.ignite.internal.sql.engine.rel"}).addClassLoader(IgniteUtils.igniteClassLoader()).enableClassInfo().scan();){
            List types = scanResult.getClassesImplementing(IgniteRel.class.getName()).filter(classInfo -> !classInfo.isInterface()).filter(classInfo -> !classInfo.isAbstract()).stream().map(classInfo -> classInfo.loadClass()).collect(Collectors.toList());
            JaninoRelMetadataProvider.DEFAULT.register(types);
        }
        SOURCE_DISTRIBUTION_INITIAL_HANDLER = (IgniteMetadata.FragmentMappingMetadata.Handler)RelMetadataQueryEx.initialHandler(IgniteMetadata.FragmentMappingMetadata.Handler.class);
    }
}

