/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.util.Arrays;
import org.apache.ignite.internal.metastorage.server.AbstractSimpleCondition;
import org.apache.ignite.internal.metastorage.server.Entry;
import org.jetbrains.annotations.NotNull;

public class ValueCondition
extends AbstractSimpleCondition {
    @NotNull
    private final Type type;
    @NotNull
    private final byte[] val;

    public ValueCondition(@NotNull Type type, @NotNull byte[] key, @NotNull byte[] val) {
        super(key);
        this.type = type;
        this.val = val;
    }

    @Override
    public boolean test(@NotNull Entry e) {
        int res = Arrays.compare(e.value(), this.val);
        return this.type.test(res);
    }

    public static enum Type {
        EQUAL{

            @Override
            public boolean test(long res) {
                return res == 0L;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public boolean test(long res) {
                return res != 0L;
            }
        }
        ,
        GREATER{

            @Override
            public boolean test(long res) {
                return res > 0L;
            }
        }
        ,
        LESS{

            @Override
            public boolean test(long res) {
                return res < 0L;
            }
        }
        ,
        LESS_OR_EQUAL{

            @Override
            public boolean test(long res) {
                return res <= 0L;
            }
        }
        ,
        GREATER_OR_EQUAL{

            @Override
            public boolean test(long res) {
                return res >= 0L;
            }
        };


        public abstract boolean test(long var1);
    }
}

