/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.persistence;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.ignite.internal.metastorage.server.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RocksStorageUtils {
    private static final VarHandle LONG_ARRAY_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);

    RocksStorageUtils() {
    }

    static byte[] longToBytes(long value) {
        byte[] buffer = new byte[8];
        LONG_ARRAY_HANDLE.set(buffer, 0, value);
        return buffer;
    }

    static long bytesToLong(byte[] array) {
        assert (array.length == 8);
        return LONG_ARRAY_HANDLE.get(array, 0);
    }

    static byte[] keyToRocksKey(long revision, byte[] key) {
        byte[] buffer = new byte[8 + key.length];
        LONG_ARRAY_HANDLE.set(buffer, 0, revision);
        System.arraycopy(key, 0, buffer, 8, key.length);
        return buffer;
    }

    static byte[] rocksKeyToBytes(byte[] rocksKey) {
        return Arrays.copyOfRange(rocksKey, 8, rocksKey.length);
    }

    static long revisionFromRocksKey(byte[] rocksKey) {
        return LONG_ARRAY_HANDLE.get(rocksKey, 0);
    }

    static Value bytesToValue(byte[] valueBytes) {
        assert (valueBytes.length > 8);
        long updateCounter = LONG_ARRAY_HANDLE.get(valueBytes, 0);
        boolean hasValue = valueBytes[8] != 0;
        byte[] val = hasValue ? Arrays.copyOfRange(valueBytes, 9, valueBytes.length) : Value.TOMBSTONE;
        return new Value(val, updateCounter);
    }

    static byte[] valueToBytes(byte[] value, long updateCounter) {
        byte[] bytes = new byte[9 + value.length];
        LONG_ARRAY_HANDLE.set(bytes, 0, updateCounter);
        bytes[8] = (byte)(value != Value.TOMBSTONE ? 1 : 0);
        System.arraycopy(value, 0, bytes, 9, value.length);
        return bytes;
    }

    @NotNull
    static long[] getAsLongs(byte[] bytes) {
        assert (bytes.length % 8 == 0);
        return IntStream.range(0, bytes.length / 8).mapToLong(i -> LONG_ARRAY_HANDLE.get(bytes, i * 8)).toArray();
    }

    static byte @NotNull [] appendLong(byte @Nullable [] bytes, long value) {
        if (bytes == null) {
            return RocksStorageUtils.longToBytes(value);
        }
        byte[] result = new byte[bytes.length + 8];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        LONG_ARRAY_HANDLE.set(result, bytes.length, value);
        return result;
    }
}

