/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.TimestampAware;
import org.apache.ignite.internal.replicator.message.TimestampAwareBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class TimestampAwareImpl
implements TimestampAware {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private HybridTimestamp timestamp;
    private byte[] timestampByteArray;

    private TimestampAwareImpl(HybridTimestamp timestamp, byte[] timestampByteArray) {
        this.timestamp = timestamp;
        this.timestampByteArray = timestampByteArray;
    }

    byte[] timestampByteArray() {
        return this.timestampByteArray;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(TimestampAwareImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimestampAwareImpl otherMessage = (TimestampAwareImpl)other;
        return Objects.equals(this.timestamp, otherMessage.timestamp);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.timestamp);
        return result;
    }

    public static TimestampAwareBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject timestampByteArraymo = marshaller.marshal((Object)this.timestamp);
        usedDescriptors.addAll((IntCollection)timestampByteArraymo.usedDescriptorIds());
        this.timestampByteArray = timestampByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.timestamp = (HybridTimestamp)marshaller.unmarshal(this.timestampByteArray, descriptorsObj);
        this.timestampByteArray = null;
    }

    private static class Builder
    implements TimestampAwareBuilder {
        private HybridTimestamp timestamp;
        private byte[] timestampByteArray;

        private Builder() {
        }

        @Override
        public TimestampAwareBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public TimestampAwareBuilder timestampByteArray(byte[] timestampByteArray) {
            this.timestampByteArray = timestampByteArray;
            return this;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] timestampByteArray() {
            return this.timestampByteArray;
        }

        @Override
        public TimestampAware build() {
            return new TimestampAwareImpl(this.timestamp, this.timestampByteArray);
        }
    }
}

