/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft;

import java.util.List;
import org.apache.ignite.raft.jraft.closure.CatchUpClosure;
import org.apache.ignite.raft.jraft.conf.ConfigurationEntry;
import org.apache.ignite.raft.jraft.core.ReplicatorType;
import org.apache.ignite.raft.jraft.entity.NodeId;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.option.ReplicatorGroupOptions;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.RpcResponseClosure;
import org.apache.ignite.raft.jraft.util.Describer;
import org.apache.ignite.raft.jraft.util.ThreadId;

public interface ReplicatorGroup
extends Describer {
    public boolean init(NodeId var1, ReplicatorGroupOptions var2);

    default public boolean addReplicator(PeerId peer) {
        return this.addReplicator(peer, ReplicatorType.Follower);
    }

    default public boolean addReplicator(PeerId peer, ReplicatorType replicatorType) {
        return this.addReplicator(peer, replicatorType, true);
    }

    public boolean addReplicator(PeerId var1, ReplicatorType var2, boolean var3);

    public void sendHeartbeat(PeerId var1, RpcResponseClosure<RpcRequests.AppendEntriesResponse> var2);

    public ThreadId getReplicator(PeerId var1);

    public void checkReplicator(PeerId var1, boolean var2);

    public void clearFailureReplicators();

    public boolean waitCaughtUp(PeerId var1, long var2, long var4, CatchUpClosure var6);

    public long getLastRpcSendTimestamp(PeerId var1);

    public boolean stopAll();

    public boolean stopReplicator(PeerId var1);

    public boolean resetTerm(long var1);

    public boolean resetHeartbeatInterval(int var1);

    public boolean resetElectionTimeoutInterval(int var1);

    public boolean contains(PeerId var1);

    public boolean transferLeadershipTo(PeerId var1, long var2);

    public boolean stopTransferLeadership(PeerId var1);

    public ThreadId stopAllAndFindTheNextCandidate(ConfigurationEntry var1);

    public PeerId findTheNextCandidate(ConfigurationEntry var1);

    public List<ThreadId> listReplicators();
}

