/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.LocalFileMetaBuilder;
import org.apache.ignite.raft.jraft.entity.LocalFileMetaOutter;

class LocalFileMetaDeserializer
implements MessageDeserializer<LocalFileMetaOutter.LocalFileMeta> {
    private final LocalFileMetaBuilder msg;

    LocalFileMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.localFileMeta();
    }

    public Class<LocalFileMetaOutter.LocalFileMeta> klass() {
        return LocalFileMetaOutter.LocalFileMeta.class;
    }

    public LocalFileMetaOutter.LocalFileMeta getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.checksum(reader.readString("checksum"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.hasUserMeta(reader.readBoolean("hasUserMeta"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.sourceByteArray(reader.readByteArray("sourceByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalFileMetaOutter.LocalFileMeta.class);
    }
}

