/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.RemoveLearnersRequestBuilder;

public class RemoveLearnersRequestImpl
implements CliRequests.RemoveLearnersRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1014;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final Collection<String> learnersList;

    private RemoveLearnersRequestImpl(String groupId, String leaderId, Collection<String> learnersList) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.learnersList = learnersList;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public Collection<String> learnersList() {
        return this.learnersList;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(RemoveLearnersRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1014;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RemoveLearnersRequestImpl otherMessage = (RemoveLearnersRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.learnersList, otherMessage.learnersList);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.leaderId, this.learnersList);
        return result;
    }

    public static RemoveLearnersRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RemoveLearnersRequestBuilder {
        private String groupId;
        private String leaderId;
        private Collection<String> learnersList;

        private Builder() {
        }

        @Override
        public RemoveLearnersRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public RemoveLearnersRequestBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public RemoveLearnersRequestBuilder learnersList(Collection<String> learnersList) {
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public CliRequests.RemoveLearnersRequest build() {
            return new RemoveLearnersRequestImpl(this.groupId, this.leaderId, this.learnersList);
        }
    }
}

