/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.TransferLeaderRequestBuilder;

public class TransferLeaderRequestImpl
implements CliRequests.TransferLeaderRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1008;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final String peerId;

    private TransferLeaderRequestImpl(String groupId, String leaderId, String peerId) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.peerId = peerId;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(TransferLeaderRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1008;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransferLeaderRequestImpl otherMessage = (TransferLeaderRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.peerId, otherMessage.peerId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.leaderId, this.peerId);
        return result;
    }

    public static TransferLeaderRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements TransferLeaderRequestBuilder {
        private String groupId;
        private String leaderId;
        private String peerId;

        private Builder() {
        }

        @Override
        public TransferLeaderRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public TransferLeaderRequestBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public TransferLeaderRequestBuilder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public CliRequests.TransferLeaderRequest build() {
            return new TransferLeaderRequestImpl(this.groupId, this.leaderId, this.peerId);
        }
    }
}

