/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.nio.ByteBuffer;
import org.apache.ignite.raft.jraft.util.CRC64;

public final class CrcUtil {
    private static final ThreadLocal<CRC64> CRC_64_THREAD_LOCAL = ThreadLocal.withInitial(CRC64::new);

    public static long crc64(byte[] array) {
        if (array == null) {
            return 0L;
        }
        return CrcUtil.crc64(array, 0, array.length);
    }

    public static long crc64(byte[] array, int offset, int length) {
        CRC64 crc64 = CRC_64_THREAD_LOCAL.get();
        crc64.update(array, offset, length);
        long ret = crc64.getValue();
        crc64.reset();
        return ret;
    }

    public static long crc64(ByteBuffer buf) {
        int pos = buf.position();
        int rem = buf.remaining();
        if (rem <= 0) {
            return 0L;
        }
        if (buf.hasArray()) {
            return CrcUtil.crc64(buf.array(), pos + buf.arrayOffset(), rem);
        }
        byte[] b = new byte[rem];
        buf.mark();
        buf.get(b);
        buf.reset();
        return CrcUtil.crc64(b);
    }

    private CrcUtil() {
    }
}

