/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.lang.ColumnNotFoundException;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientSchema {
    private final int ver;
    private final int keyColumnCount;
    private final ClientColumn[] columns;
    private final List<ClientColumn> colocationColumns;
    private final Map<String, ClientColumn> map = new HashMap<String, ClientColumn>();

    public ClientSchema(int ver, ClientColumn[] columns) {
        assert (ver >= 0);
        assert (columns != null);
        this.ver = ver;
        this.columns = columns;
        this.colocationColumns = new ArrayList<ClientColumn>();
        int keyCnt = 0;
        for (ClientColumn col : columns) {
            if (col.key()) {
                ++keyCnt;
            }
            this.map.put(col.name(), col);
            if (!col.colocation()) continue;
            this.colocationColumns.add(col);
        }
        this.keyColumnCount = keyCnt;
    }

    public int version() {
        return this.ver;
    }

    @NotNull
    public ClientColumn[] columns() {
        return this.columns;
    }

    public List<ClientColumn> colocationColumns() {
        return this.colocationColumns;
    }

    @NotNull
    public ClientColumn column(String name) {
        ClientColumn column = this.map.get(name);
        if (column == null) {
            throw new ColumnNotFoundException(name);
        }
        return column;
    }

    @Nullable
    public ClientColumn columnSafe(String name) {
        return this.map.get(name);
    }

    public int keyColumnCount() {
        return this.keyColumnCount;
    }

    public <T> Marshaller getMarshaller(Mapper mapper, TuplePart part) {
        return this.createMarshaller(mapper, part);
    }

    private Marshaller createMarshaller(Mapper mapper, TuplePart part) {
        int colCount = this.columns.length;
        int firstColIdx = 0;
        if (part == TuplePart.KEY) {
            colCount = this.keyColumnCount;
        } else if (part == TuplePart.VAL) {
            colCount = this.columns.length - this.keyColumnCount;
            firstColIdx = this.keyColumnCount;
        }
        MarshallerColumn[] cols = new MarshallerColumn[colCount];
        for (int i = 0; i < colCount; ++i) {
            ClientColumn col = this.columns[i + firstColIdx];
            cols[i] = new MarshallerColumn(col.name(), ClientSchema.mode(col.type()), null, col.scale());
        }
        return Marshaller.createMarshaller((MarshallerColumn[])cols, (Mapper)mapper, (part == TuplePart.KEY ? 1 : 0) != 0);
    }

    private static BinaryMode mode(int dataType) {
        switch (dataType) {
            case 1: {
                return BinaryMode.BYTE;
            }
            case 2: {
                return BinaryMode.SHORT;
            }
            case 3: {
                return BinaryMode.INT;
            }
            case 4: {
                return BinaryMode.LONG;
            }
            case 5: {
                return BinaryMode.FLOAT;
            }
            case 6: {
                return BinaryMode.DOUBLE;
            }
            case 8: {
                return BinaryMode.UUID;
            }
            case 9: {
                return BinaryMode.STRING;
            }
            case 10: {
                return BinaryMode.BYTE_ARR;
            }
            case 7: {
                return BinaryMode.DECIMAL;
            }
            case 16: {
                return BinaryMode.NUMBER;
            }
            case 11: {
                return BinaryMode.BITSET;
            }
            case 12: {
                return BinaryMode.DATE;
            }
            case 13: {
                return BinaryMode.TIME;
            }
            case 14: {
                return BinaryMode.DATETIME;
            }
            case 15: {
                return BinaryMode.TIMESTAMP;
            }
        }
        throw new IgniteException("Unknown client data type: " + dataType);
    }
}

