/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTuple;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.util.HashCalculator;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientTupleSerializer {
    private final UUID tableId;

    ClientTupleSerializer(UUID tableId) {
        this.tableId = tableId;
    }

    void writeTuple(@Nullable Transaction tx, @NotNull Tuple tuple, ClientSchema schema, PayloadOutputChannel out) {
        this.writeTuple(tx, tuple, schema, out, false, false);
    }

    void writeTuple(@Nullable Transaction tx, @NotNull Tuple tuple, ClientSchema schema, PayloadOutputChannel out, boolean keyOnly) {
        this.writeTuple(tx, tuple, schema, out, keyOnly, false);
    }

    void writeTuple(@Nullable Transaction tx, @NotNull Tuple tuple, ClientSchema schema, PayloadOutputChannel out, boolean keyOnly, boolean skipHeader) {
        if (!skipHeader) {
            out.out().packUuid(this.tableId);
            ClientTable.writeTx(tx, out);
            out.out().packInt(schema.version());
        }
        ClientTupleSerializer.writeTupleRaw(tuple, schema, out, keyOnly);
    }

    public static void writeTupleRaw(@NotNull Tuple tuple, ClientSchema schema, PayloadOutputChannel out, boolean keyOnly) {
        ClientColumn[] columns = schema.columns();
        int count = keyOnly ? schema.keyColumnCount() : columns.length;
        BinaryTupleBuilder builder = new BinaryTupleBuilder(count, true);
        BitSet noValueSet = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            ClientColumn col = columns[i];
            Object v = tuple.valueOrDefault(col.name(), ClientMessageCommon.NO_VALUE);
            ClientTupleSerializer.appendValue(builder, noValueSet, col, v);
        }
        out.out().packBinaryTuple(builder, noValueSet);
    }

    void writeKvTuple(@Nullable Transaction tx, @NotNull Tuple key, @Nullable Tuple val, ClientSchema schema, PayloadOutputChannel out, boolean skipHeader) {
        if (!skipHeader) {
            out.out().packUuid(this.tableId);
            ClientTable.writeTx(tx, out);
            out.out().packInt(schema.version());
        }
        ClientColumn[] columns = schema.columns();
        BitSet noValueSet = new BitSet(columns.length);
        BinaryTupleBuilder builder = new BinaryTupleBuilder(columns.length, true);
        for (int i = 0; i < columns.length; ++i) {
            ClientColumn col = columns[i];
            Object v = col.key() ? key.valueOrDefault(col.name(), ClientMessageCommon.NO_VALUE) : (val != null ? val.valueOrDefault(col.name(), ClientMessageCommon.NO_VALUE) : ClientMessageCommon.NO_VALUE);
            ClientTupleSerializer.appendValue(builder, noValueSet, col, v);
        }
        out.out().packBinaryTuple(builder, noValueSet);
    }

    void writeKvTuples(@Nullable Transaction tx, Map<Tuple, Tuple> pairs, ClientSchema schema, PayloadOutputChannel out) {
        out.out().packUuid(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        out.out().packInt(pairs.size());
        for (Map.Entry<Tuple, Tuple> pair : pairs.entrySet()) {
            this.writeKvTuple(tx, pair.getKey(), pair.getValue(), schema, out, true);
        }
    }

    void writeTuples(@Nullable Transaction tx, @NotNull Collection<Tuple> tuples, ClientSchema schema, PayloadOutputChannel out, boolean keyOnly) {
        out.out().packUuid(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        out.out().packInt(tuples.size());
        for (Tuple tuple : tuples) {
            this.writeTuple(tx, tuple, schema, out, keyOnly, true);
        }
    }

    static Tuple readTuple(ClientSchema schema, ClientMessageUnpacker in, boolean keyOnly) {
        ClientTuple tuple = new ClientTuple(schema);
        int colCnt = keyOnly ? schema.keyColumnCount() : schema.columns().length;
        BinaryTupleReader binTuple = new BinaryTupleReader(colCnt, in.readBinaryUnsafe());
        for (int i = 0; i < colCnt; ++i) {
            ClientColumn column = schema.columns()[i];
            ClientBinaryTupleUtils.readAndSetColumnValue((BinaryTupleReader)binTuple, (int)i, (Tuple)tuple, (String)column.name(), (int)column.type(), (int)column.scale());
        }
        return tuple;
    }

    static Tuple readValueTuple(ClientSchema schema, ClientMessageUnpacker in, Tuple keyTuple) {
        ClientTuple tuple = new ClientTuple(schema);
        BinaryTupleReader binTuple = new BinaryTupleReader(schema.columns().length - schema.keyColumnCount(), in.readBinaryUnsafe());
        for (int i = 0; i < schema.columns().length; ++i) {
            ClientColumn col = schema.columns()[i];
            if (i < schema.keyColumnCount()) {
                tuple.setInternal(i, keyTuple.value(col.name()));
                continue;
            }
            ClientBinaryTupleUtils.readAndSetColumnValue((BinaryTupleReader)binTuple, (int)(i - schema.keyColumnCount()), (Tuple)tuple, (String)col.name(), (int)col.type(), (int)col.scale());
        }
        return tuple;
    }

    static Tuple readValueTuple(ClientSchema schema, ClientMessageUnpacker in) {
        int keyColCnt = schema.keyColumnCount();
        int colCnt = schema.columns().length;
        ClientTuple valTuple = new ClientTuple(schema, keyColCnt, schema.columns().length - 1);
        BinaryTupleReader binTupleReader = new BinaryTupleReader(colCnt - keyColCnt, in.readBinaryUnsafe());
        for (int i = keyColCnt; i < colCnt; ++i) {
            ClientColumn col = schema.columns()[i];
            ClientBinaryTupleUtils.readAndSetColumnValue((BinaryTupleReader)binTupleReader, (int)(i - keyColCnt), (Tuple)valTuple, (String)col.name(), (int)col.type(), (int)col.scale());
        }
        return valTuple;
    }

    static IgniteBiTuple<Tuple, Tuple> readKvTuple(ClientSchema schema, ClientMessageUnpacker in) {
        int keyColCnt = schema.keyColumnCount();
        int colCnt = schema.columns().length;
        ClientTuple keyTuple = new ClientTuple(schema, 0, keyColCnt - 1);
        ClientTuple valTuple = new ClientTuple(schema, keyColCnt, schema.columns().length - 1);
        BinaryTupleReader binTuple = new BinaryTupleReader(colCnt, in.readBinaryUnsafe());
        for (int i = 0; i < colCnt; ++i) {
            ClientColumn col = schema.columns()[i];
            ClientTuple targetTuple = i < keyColCnt ? keyTuple : valTuple;
            ClientBinaryTupleUtils.readAndSetColumnValue((BinaryTupleReader)binTuple, (int)i, (Tuple)targetTuple, (String)col.name(), (int)col.type(), (int)col.scale());
        }
        return new IgniteBiTuple((Object)keyTuple, (Object)valTuple);
    }

    static Map<Tuple, Tuple> readKvTuplesNullable(ClientSchema schema, ClientMessageUnpacker in) {
        int cnt = in.unpackInt();
        HashMap<Tuple, Tuple> res = new HashMap<Tuple, Tuple>(cnt);
        for (int i = 0; i < cnt; ++i) {
            boolean hasValue = in.unpackBoolean();
            if (!hasValue) continue;
            IgniteBiTuple<Tuple, Tuple> pair = ClientTupleSerializer.readKvTuple(schema, in);
            res.put((Tuple)pair.get1(), (Tuple)pair.get2());
        }
        return res;
    }

    static Collection<Tuple> readTuples(ClientSchema schema, ClientMessageUnpacker in) {
        return ClientTupleSerializer.readTuples(schema, in, false);
    }

    static Collection<Tuple> readTuples(ClientSchema schema, ClientMessageUnpacker in, boolean keyOnly) {
        int cnt = in.unpackInt();
        ArrayList<Tuple> res = new ArrayList<Tuple>(cnt);
        for (int i = 0; i < cnt; ++i) {
            res.add(ClientTupleSerializer.readTuple(schema, in, keyOnly));
        }
        return res;
    }

    static Collection<Tuple> readTuplesNullable(ClientSchema schema, ClientMessageUnpacker in) {
        int cnt = in.unpackInt();
        ArrayList<Tuple> res = new ArrayList<Tuple>(cnt);
        for (int i = 0; i < cnt; ++i) {
            Tuple tuple = in.unpackBoolean() ? ClientTupleSerializer.readTuple(schema, in, false) : null;
            res.add(tuple);
        }
        return res;
    }

    private static void appendValue(BinaryTupleBuilder builder, BitSet noValueSet, ClientColumn col, Object v) {
        if (v == null) {
            builder.appendNull();
            return;
        }
        if (v == ClientMessageCommon.NO_VALUE) {
            noValueSet.set(col.schemaIndex());
            builder.appendDefault();
            return;
        }
        try {
            switch (col.type()) {
                case 1: {
                    builder.appendByte(((Byte)v).byteValue());
                    return;
                }
                case 2: {
                    builder.appendShort(((Short)v).shortValue());
                    return;
                }
                case 3: {
                    builder.appendInt(((Integer)v).intValue());
                    return;
                }
                case 4: {
                    builder.appendLong(((Long)v).longValue());
                    return;
                }
                case 5: {
                    builder.appendFloat(((Float)v).floatValue());
                    return;
                }
                case 6: {
                    builder.appendDouble(((Double)v).doubleValue());
                    return;
                }
                case 7: {
                    builder.appendDecimalNotNull((BigDecimal)v, col.scale());
                    return;
                }
                case 8: {
                    builder.appendUuidNotNull((UUID)v);
                    return;
                }
                case 9: {
                    builder.appendStringNotNull((String)v);
                    return;
                }
                case 10: {
                    builder.appendBytesNotNull((byte[])v);
                    return;
                }
                case 11: {
                    builder.appendBitmaskNotNull((BitSet)v);
                    return;
                }
                case 12: {
                    builder.appendDateNotNull((LocalDate)v);
                    return;
                }
                case 13: {
                    builder.appendTimeNotNull((LocalTime)v);
                    return;
                }
                case 14: {
                    builder.appendDateTimeNotNull((LocalDateTime)v);
                    return;
                }
                case 15: {
                    builder.appendTimestampNotNull((Instant)v);
                    return;
                }
                case 16: {
                    builder.appendNumberNotNull((BigInteger)v);
                    return;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + col.type());
        }
        catch (ClassCastException e) {
            throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Incorrect value type for column '" + col.name() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    static Function<ClientSchema, Integer> getHashFunction(@Nullable Transaction tx, @NotNull Tuple rec) {
        return tx != null ? null : schema -> ClientTupleSerializer.getColocationHash(schema, rec);
    }

    @Nullable
    static Function<ClientSchema, Integer> getHashFunction(@Nullable Transaction tx, Mapper<?> mapper, @NotNull Object rec) {
        return tx != null ? null : schema -> ClientTupleSerializer.getColocationHash(schema, mapper, rec);
    }

    private static Integer getColocationHash(ClientSchema schema, Tuple rec) {
        HashCalculator hashCalc = new HashCalculator();
        for (ClientColumn col : schema.colocationColumns()) {
            Object value = rec.valueOrDefault(col.name(), null);
            hashCalc.append(value);
        }
        return hashCalc.hash();
    }

    private static Integer getColocationHash(ClientSchema schema, Mapper<?> mapper, Object rec) {
        HashCalculator hashCalc = new HashCalculator();
        Marshaller marsh = schema.getMarshaller(mapper, TuplePart.KEY);
        for (ClientColumn col : schema.colocationColumns()) {
            Object value = marsh.value(rec, col.schemaIndex());
            hashCalc.append(value);
        }
        return hashCalc.hash();
    }
}

