/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.replacement;

import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.LoadedPagesMap;
import org.apache.ignite.internal.pagememory.persistence.PageHeader;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.replacement.ClockPageReplacementFlags;
import org.apache.ignite.internal.pagememory.persistence.replacement.PageReplacementPolicy;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class ClockPageReplacementPolicy
extends PageReplacementPolicy {
    private final ClockPageReplacementFlags flags;

    public ClockPageReplacementPolicy(PersistentPageMemory.Segment seg, long ptr, int pagesCnt) {
        super(seg);
        this.flags = new ClockPageReplacementFlags(pagesCnt, ptr);
    }

    @Override
    public void onHit(long relPtr) {
        int pageIdx = (int)this.seg.pageIndex(relPtr);
        this.flags.setFlag(pageIdx);
    }

    @Override
    public void onRemove(long relPtr) {
        int pageIdx = (int)this.seg.pageIndex(relPtr);
        this.flags.clearFlag(pageIdx);
    }

    @Override
    public long replace() throws IgniteInternalCheckedException {
        LoadedPagesMap loadedPages = this.seg.loadedPages();
        for (int i = 0; i < loadedPages.size(); ++i) {
            int pageIdx = this.flags.poll();
            long relPtr = this.seg.relative(pageIdx);
            long absPtr = this.seg.absolute(relPtr);
            FullPageId fullId = PageHeader.fullPageId(absPtr);
            relPtr = loadedPages.get(fullId.groupId(), fullId.effectivePageId(), this.seg.partGeneration(fullId.groupId(), PageIdUtils.partitionId(fullId.pageId())), 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            assert (relPtr != 0xFFFFFFFFFFFFFFL);
            if (relPtr == 0x100000000000000L) {
                return this.seg.refreshOutdatedPage(fullId.groupId(), fullId.pageId(), true);
            }
            if (this.seg.tryToRemovePage(fullId, absPtr)) {
                return relPtr;
            }
            this.flags.setFlag(pageIdx);
        }
        throw this.seg.oomException("no pages to replace");
    }
}

