/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryCursorHandler;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCloseRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCloseResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryFetchRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryFetchResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.sql.SqlColumnTypeConverter;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlColumnType;

public class JdbcQueryCursorHandlerImpl
implements JdbcQueryCursorHandler {
    private final ClientResourceRegistry resources;

    public JdbcQueryCursorHandlerImpl(ClientResourceRegistry resources) {
        this.resources = resources;
    }

    public CompletableFuture<JdbcQueryFetchResult> fetchAsync(JdbcQueryFetchRequest req) {
        AsyncSqlCursor asyncSqlCursor = null;
        try {
            asyncSqlCursor = this.resources.get(req.cursorId()).get(AsyncSqlCursor.class);
        }
        catch (IgniteInternalCheckedException e) {
            StringWriter sw = this.getWriterWithStackTrace(e);
            return CompletableFuture.completedFuture(new JdbcQueryFetchResult(1, "Failed to find query cursor [curId=" + req.cursorId() + "]. Error message:" + sw));
        }
        if (req.pageSize() <= 0) {
            return CompletableFuture.completedFuture(new JdbcQueryFetchResult(1, "Invalid fetch size [fetchSize=" + req.pageSize() + "]"));
        }
        return ((CompletableFuture)asyncSqlCursor.requestNextAsync(req.pageSize()).handle((batch, t) -> {
            if (t != null) {
                StringWriter sw = this.getWriterWithStackTrace((Throwable)t);
                return new JdbcQueryFetchResult(1, "Failed to fetch query results [curId=" + req.cursorId() + "]. Error message:" + sw);
            }
            return new JdbcQueryFetchResult(batch.items(), !batch.hasMore());
        })).toCompletableFuture();
    }

    public CompletableFuture<JdbcQueryCloseResult> closeAsync(JdbcQueryCloseRequest req) {
        AsyncSqlCursor asyncSqlCursor = null;
        try {
            asyncSqlCursor = this.resources.remove(req.cursorId()).get(AsyncSqlCursor.class);
        }
        catch (IgniteInternalCheckedException e) {
            StringWriter sw = this.getWriterWithStackTrace(e);
            return CompletableFuture.completedFuture(new JdbcQueryCloseResult(1, "Failed to find query cursor [curId=" + req.cursorId() + "]. Error message:" + sw));
        }
        return asyncSqlCursor.closeAsync().handle((none, t) -> {
            if (t != null) {
                StringWriter sw = this.getWriterWithStackTrace((Throwable)t);
                return new JdbcQueryCloseResult(1, "Failed to close SQL query cursor [curId=" + req.cursorId() + "]. Error message: " + sw);
            }
            return new JdbcQueryCloseResult();
        });
    }

    public CompletableFuture<JdbcMetaColumnsResult> queryMetadataAsync(JdbcQueryMetadataRequest req) {
        AsyncSqlCursor asyncSqlCursor = null;
        try {
            asyncSqlCursor = this.resources.get(req.cursorId()).get(AsyncSqlCursor.class);
        }
        catch (IgniteInternalCheckedException e) {
            StringWriter sw = this.getWriterWithStackTrace(e);
            return CompletableFuture.completedFuture(new JdbcMetaColumnsResult(1, "Failed to find query cursor [curId=" + req.cursorId() + "]. Error message:" + sw));
        }
        ResultSetMetadata metadata = asyncSqlCursor.metadata();
        if (metadata == null) {
            return CompletableFuture.completedFuture(new JdbcMetaColumnsResult(1, "Failed to get query metadata for cursor [curId=" + req.cursorId() + "]"));
        }
        List meta = metadata.columns().stream().map(this::createColumnMetadata).collect(Collectors.toList());
        return CompletableFuture.completedFuture(new JdbcMetaColumnsResult(meta));
    }

    private JdbcColumnMeta createColumnMetadata(ColumnMetadata fldMeta) {
        ColumnMetadata.ColumnOrigin origin = fldMeta.origin();
        String schemaName = null;
        String tblName = null;
        String colName = null;
        if (origin != null) {
            schemaName = origin.schemaName();
            tblName = origin.tableName();
            colName = origin.columnName();
        }
        return new JdbcColumnMeta(fldMeta.name(), schemaName, tblName, colName, SqlColumnTypeConverter.columnTypeToClass((SqlColumnType)fldMeta.type()), fldMeta.precision(), fldMeta.scale(), fldMeta.nullable());
    }

    private StringWriter getWriterWithStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw;
    }
}

