/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.common.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.raft.client.WriteCommand;
import org.jetbrains.annotations.NotNull;

public final class PutAllCommand
implements WriteCommand {
    private final List<byte[]> keys;
    private final List<byte[]> vals;

    public PutAllCommand(@NotNull Map<ByteArray, byte[]> vals) {
        assert (!vals.isEmpty());
        int size = vals.size();
        this.keys = new ArrayList<byte[]>(size);
        this.vals = new ArrayList<byte[]>(size);
        for (Map.Entry<ByteArray, byte[]> e : vals.entrySet()) {
            byte[] key = e.getKey().bytes();
            byte[] val = e.getValue();
            assert (key != null) : "Key could not be null.";
            assert (val != null) : "Value could not be null.";
            this.keys.add(key);
            this.vals.add(val);
        }
    }

    @NotNull
    public List<byte[]> keys() {
        return this.keys;
    }

    @NotNull
    public List<byte[]> values() {
        return this.vals;
    }
}

