/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.config;

import java.io.File;
import java.nio.file.Path;

public final class StateFolderProvider {
    private static final String XDG_STATE_HOME = "XDG_STATE_HOME";
    private static final String PARENT_FOLDER_NAME = "ignitecli";

    private StateFolderProvider() {
    }

    public static File getStateFile(String name) {
        return StateFolderProvider.getStateRoot().resolve(PARENT_FOLDER_NAME).resolve(name).toFile();
    }

    private static Path getStateRoot() {
        String xdgStateHome = System.getenv(XDG_STATE_HOME);
        if (xdgStateHome != null) {
            return Path.of(xdgStateHome, new String[0]);
        }
        return Path.of(System.getProperty("user.home"), ".local", "state");
    }
}

