/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.lang.IgniteException;

public class ClientMessageDecoder
extends LengthFieldBasedFrameDecoder {
    private boolean magicDecoded;
    private boolean magicFailed;

    public ClientMessageDecoder() {
        super(0x7FFFFFFB, 0, 4, 0, 4, true);
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (!this.readMagic(in)) {
            return null;
        }
        return super.decode(ctx, in);
    }

    private boolean readMagic(ByteBuf byteBuf) {
        if (this.magicFailed) {
            return false;
        }
        if (this.magicDecoded) {
            return true;
        }
        if (byteBuf.readableBytes() < ClientMessageCommon.MAGIC_BYTES.length) {
            return false;
        }
        byte[] data = new byte[ClientMessageCommon.MAGIC_BYTES.length];
        byteBuf.readBytes(data);
        this.magicDecoded = true;
        if (Arrays.equals(data, ClientMessageCommon.MAGIC_BYTES)) {
            return true;
        }
        this.magicFailed = true;
        byteBuf.release();
        throw new IgniteException("Invalid magic header in thin client connection. Expected 'IGNI', but was '" + new String(data, CharsetUtil.US_ASCII) + "'.");
    }
}

