/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class JdbcQueryFetchResult
extends Response {
    private List<List<Object>> items;
    private boolean last;

    public JdbcQueryFetchResult() {
    }

    public JdbcQueryFetchResult(int status, String err) {
        super(status, err);
    }

    public JdbcQueryFetchResult(List<List<Object>> items, boolean last) {
        Objects.requireNonNull(items);
        this.items = items;
        this.last = last;
        this.hasResults = true;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean last() {
        return this.last;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.hasResults) {
            return;
        }
        packer.packBoolean(this.last);
        packer.packArrayHeader(this.items.size());
        for (List<Object> item : this.items) {
            packer.packObjectArrayAsBinaryTuple(item.toArray());
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.hasResults) {
            return;
        }
        this.last = unpacker.unpackBoolean();
        int size = unpacker.unpackArrayHeader();
        this.items = new ArrayList<List<Object>>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(Arrays.asList(unpacker.unpackObjectArrayFromBinaryTuple()));
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryFetchResult.class, (Object)this);
    }
}

