/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.math.BigDecimal;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.rules.ImmutableIntersectToDistinctRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.immutables.value.Value;

@Value.Enclosing
public class IntersectToDistinctRule
extends RelRule<Config>
implements TransformationRule {
    protected IntersectToDistinctRule(Config config) {
        super(config);
    }

    @Deprecated
    public IntersectToDistinctRule(Class<? extends Intersect> intersectClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(intersectClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        if (intersect.all) {
            return;
        }
        RelOptCluster cluster = intersect.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelBuilder relBuilder = call.builder();
        for (RelNode input : intersect.getInputs()) {
            relBuilder.push(input);
            relBuilder.aggregate(relBuilder.groupKey((Iterable<? extends RexNode>)relBuilder.fields()), relBuilder.countStar(null));
        }
        int branchCount = intersect.getInputs().size();
        relBuilder.union(true, branchCount);
        RelNode union = relBuilder.peek();
        int fieldCount = union.getRowType().getFieldCount();
        ImmutableBitSet groupSet = ImmutableBitSet.range(fieldCount - 1);
        relBuilder.aggregate(relBuilder.groupKey(groupSet), relBuilder.countStar(null));
        relBuilder.filter(relBuilder.equals(relBuilder.field(fieldCount - 1), rexBuilder.makeBigintLiteral(new BigDecimal(branchCount))));
        relBuilder.project(Util.skipLast(relBuilder.fields()));
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIntersectToDistinctRule.Config.of().withOperandFor(LogicalIntersect.class);

        @Override
        default public IntersectToDistinctRule toRule() {
            return new IntersectToDistinctRule(this);
        }

        default public Config withOperandFor(Class<? extends Intersect> intersectClass) {
            return this.withOperandSupplier(b -> b.operand(intersectClass).anyInputs()).as(Config.class);
        }
    }
}

