/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HandshakeStartMessageImpl
implements HandshakeStartMessage {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final String consistentId;
    @IgniteToStringInclude
    private final UUID launchId;

    private HandshakeStartMessageImpl(String consistentId, UUID launchId) {
        this.consistentId = consistentId;
        this.launchId = launchId;
    }

    @Override
    public String consistentId() {
        return this.consistentId;
    }

    @Override
    public UUID launchId() {
        return this.launchId;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeStartMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeStartMessageImpl otherMessage = (HandshakeStartMessageImpl)other;
        return Objects.equals(this.consistentId, otherMessage.consistentId) && Objects.equals(this.launchId, otherMessage.launchId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.consistentId, this.launchId);
        return result;
    }

    public static HandshakeStartMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements HandshakeStartMessageBuilder {
        private String consistentId;
        private UUID launchId;

        private Builder() {
        }

        @Override
        public HandshakeStartMessageBuilder consistentId(String consistentId) {
            this.consistentId = consistentId;
            return this;
        }

        @Override
        public HandshakeStartMessageBuilder launchId(UUID launchId) {
            this.launchId = launchId;
            return this;
        }

        @Override
        public String consistentId() {
            return this.consistentId;
        }

        @Override
        public UUID launchId() {
            return this.launchId;
        }

        @Override
        public HandshakeStartMessage build() {
            return new HandshakeStartMessageImpl(this.consistentId, this.launchId);
        }
    }
}

