/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.ObjectInput;
import java.io.ObjectInputStream;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchException;

public interface SchemaMismatchHandler<T> {
    default public void onFieldIgnored(T instance, String fieldName, Object fieldValue) throws SchemaMismatchException {
    }

    default public void onFieldMissed(T instance, String fieldName) throws SchemaMismatchException {
    }

    default public void onFieldTypeChanged(T instance, String fieldName, Class<?> remoteType, Object fieldValue) throws SchemaMismatchException {
        throw new SchemaMismatchException(fieldName + " type changed, serialized as " + remoteType.getName() + ", value " + fieldValue + " of type " + fieldName.getClass().getName());
    }

    default public void onExternalizableIgnored(T instance, ObjectInput externalData) throws SchemaMismatchException {
        throw new SchemaMismatchException("Class " + instance.getClass().getName() + " was serialized as an Externalizable remotely, but locally it is not an Externalizable");
    }

    default public void onExternalizableMissed(T instance) throws SchemaMismatchException {
    }

    default public void onReadResolveDisappeared(T instance) throws SchemaMismatchException {
    }

    default public boolean onReadResolveAppeared(T instance) throws SchemaMismatchException {
        return true;
    }

    default public void onReadObjectIgnored(T instance, ObjectInputStream objectData) throws SchemaMismatchException {
        throw new SchemaMismatchException("Class " + instance.getClass().getName() + " was serialized with writeObject() remotely, but locally it has no readObject()");
    }

    default public void onReadObjectMissed(T instance) throws SchemaMismatchException {
    }
}

