/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.Timestamp;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.impl.ReadOnlyTransactionImpl;
import org.apache.ignite.internal.tx.impl.ReadWriteTransactionImpl;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.TestOnly;

public class TxManagerImpl
implements TxManager {
    private static final TxMessagesFactory FACTORY = new TxMessagesFactory();
    private ReplicaService replicaService;
    private final LockManager lockManager;
    private final HybridClock clock;
    @TestOnly
    private final ConcurrentHashMap<UUID, TxState> states = new ConcurrentHashMap();

    public TxManagerImpl(ReplicaService replicaService, LockManager lockManager, HybridClock clock) {
        this.replicaService = replicaService;
        this.lockManager = lockManager;
        this.clock = clock;
    }

    @Override
    public InternalTransaction begin() {
        return this.begin(false);
    }

    @Override
    public InternalTransaction begin(boolean readOnly) {
        UUID txId = Timestamp.nextVersion().toUuid();
        return readOnly ? new ReadOnlyTransactionImpl(this, txId, this.clock.now()) : new ReadWriteTransactionImpl(this, txId);
    }

    @Override
    public TxState state(UUID txId) {
        return this.states.get(txId);
    }

    @Override
    public boolean changeState(UUID txId, TxState before, TxState after) {
        return this.states.compute(txId, (k, v) -> {
            if (v == before) {
                return after;
            }
            return v;
        }) == after;
    }

    @Override
    public CompletableFuture<Void> finish(ReplicationGroupId commitPartition, ClusterNode recipientNode, Long term, boolean commit, Map<ClusterNode, List<IgniteBiTuple<ReplicationGroupId, Long>>> groups, UUID txId) {
        assert (groups != null && !groups.isEmpty());
        HybridTimestamp commitTimestamp = commit ? this.clock.now() : null;
        TxFinishReplicaRequest req = FACTORY.txFinishReplicaRequest().txId(txId).groupId(commitPartition).groups(groups).commit(commit).commitTimestamp(commitTimestamp).term(term).build();
        return this.replicaService.invoke(recipientNode, (ReplicaRequest)req).thenRun(() -> this.changeState(txId, null, commit ? TxState.COMMITED : TxState.ABORTED));
    }

    @Override
    public CompletableFuture<Void> cleanup(ClusterNode recipientNode, List<IgniteBiTuple<ReplicationGroupId, Long>> replicationGroupIds, UUID txId, boolean commit, HybridTimestamp commitTimestamp) {
        CompletableFuture[] cleanupFutures = new CompletableFuture[replicationGroupIds.size()];
        for (int i = 0; i < replicationGroupIds.size(); ++i) {
            cleanupFutures[i] = this.replicaService.invoke(recipientNode, (ReplicaRequest)FACTORY.txCleanupReplicaRequest().groupId((ReplicationGroupId)replicationGroupIds.get(i).get1()).txId(txId).commit(commit).commitTimestamp(commitTimestamp).term((Long)replicationGroupIds.get(i).get2()).build());
        }
        return CompletableFuture.allOf(cleanupFutures);
    }

    @Override
    public int finished() {
        return (int)this.states.entrySet().stream().filter(e -> e.getValue() == TxState.COMMITED || e.getValue() == TxState.ABORTED).count();
    }

    public void start() {
    }

    public void stop() throws Exception {
    }

    @Override
    public LockManager lockManager() {
        return this.lockManager;
    }
}

