/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.tostring.S;

public class NumberNativeType
extends NativeType {
    private final int precision;

    protected NumberNativeType(int precision) {
        super(NativeTypeSpec.NUMBER);
        this.precision = precision;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberNativeType that = (NumberNativeType)o;
        return this.precision == that.precision;
    }

    @Override
    public boolean mismatch(NativeType type) {
        return super.mismatch(type) || this.precision < ((NumberNativeType)type).precision;
    }

    @Override
    public int hashCode() {
        return this.precision;
    }

    @Override
    public int compareTo(NativeType o) {
        int res = super.compareTo(o);
        if (res == 0) {
            NumberNativeType that = (NumberNativeType)o;
            return Integer.compare(this.precision, that.precision);
        }
        return res;
    }

    @Override
    public String toString() {
        return S.toString((String)NumberNativeType.class.getSimpleName(), (String)"typeSpec", (Object)((Object)this.spec()), (String)"precision", (Object)this.precision());
    }
}

