/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.schema.configuration.TableValidator;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.util.ArrayUtils;

public class TableValidatorImpl
implements Validator<TableValidator, NamedListView<TableView>> {
    public static final TableValidatorImpl INSTANCE = new TableValidatorImpl();

    public void validate(TableValidator annotation, ValidationContext<NamedListView<TableView>> ctx) {
        NamedListView newTables = (NamedListView)ctx.getNewValue();
        for (String tableName : this.newKeys((NamedListView)ctx.getOldValue(), (NamedListView)ctx.getNewValue())) {
            Set<String> colocationDups;
            Set<String> pkDups;
            TableView newTable = (TableView)newTables.get(tableName);
            if (newTable.columns() == null || newTable.columns().size() == 0) {
                ctx.addIssue(new ValidationIssue(newTable.name(), "Table should include at least one column"));
                return;
            }
            Set<String> columnsDups = this.findDuplicates(newTable.columns().namedListKeys());
            if (!columnsDups.isEmpty()) {
                ctx.addIssue(new ValidationIssue(newTable.name(), "Some columns are specified more than once [duplicates=" + new HashSet<String>(columnsDups) + "]"));
            }
            HashSet columns = new HashSet(newTable.columns().namedListKeys());
            if (newTable.primaryKey() == null || ArrayUtils.nullOrEmpty((Object[])newTable.primaryKey().columns())) {
                ctx.addIssue(new ValidationIssue(newTable.name(), "Table without primary key is not supported"));
                return;
            }
            List<String> pkColumns = Arrays.asList(newTable.primaryKey().columns());
            if (!columns.containsAll(pkColumns)) {
                HashSet<String> missingColumns = new HashSet<String>(pkColumns);
                missingColumns.removeAll(columns);
                ctx.addIssue(new ValidationIssue(newTable.name(), "Columns don't exists [columns=" + missingColumns + "]"));
            }
            if (!(pkDups = this.findDuplicates(pkColumns)).isEmpty()) {
                ctx.addIssue(new ValidationIssue(newTable.name(), "Primary key contains duplicated columns [duplicates=" + pkDups + "]"));
            }
            if (ArrayUtils.nullOrEmpty((Object[])newTable.primaryKey().colocationColumns())) {
                ctx.addIssue(new ValidationIssue(newTable.name(), "Colocation columns must be specified"));
                return;
            }
            HashSet<String> outstandingColumns = new HashSet<String>(Arrays.asList(newTable.primaryKey().colocationColumns()));
            outstandingColumns.removeAll(Arrays.asList(newTable.primaryKey().columns()));
            if (!outstandingColumns.isEmpty()) {
                ctx.addIssue(new ValidationIssue(newTable.name(), "Colocation columns must be subset of primary key [outstandingColumns=" + outstandingColumns + "]"));
            }
            if ((colocationDups = this.findDuplicates(Arrays.asList(newTable.primaryKey().colocationColumns()))).isEmpty()) continue;
            ctx.addIssue(new ValidationIssue(newTable.name(), "Colocation columns contains duplicates [duplicates=" + colocationDups + "]"));
        }
    }

    private TableValidatorImpl() {
    }

    private List<String> newKeys(NamedListView<?> before, NamedListView<?> after) {
        ArrayList<String> result = new ArrayList<String>(after.namedListKeys());
        if (before != null) {
            result.removeAll(before.namedListKeys());
        }
        return result;
    }

    private Set<String> findDuplicates(Collection<String> collection) {
        HashSet<String> used = new HashSet<String>();
        HashSet<String> result = new HashSet<String>();
        for (String element : collection) {
            if (used.add(element)) continue;
            result.add(element);
        }
        return result;
    }
}

