/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.scheduling.instrument.InstrumentedExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public interface InstrumentedExecutorService
extends ExecutorService,
InstrumentedExecutor {
    @Override
    public ExecutorService getTarget();

    default public <T> Callable<T> instrument(Callable<T> task) {
        return task;
    }

    @Override
    default public void shutdown() {
        this.getTarget().shutdown();
    }

    @Override
    default public List<Runnable> shutdownNow() {
        return this.getTarget().shutdownNow();
    }

    @Override
    default public boolean isShutdown() {
        return this.getTarget().isShutdown();
    }

    @Override
    default public boolean isTerminated() {
        return this.getTarget().isTerminated();
    }

    @Override
    default public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return this.getTarget().awaitTermination(timeout, unit);
    }

    @Override
    @NonNull
    default public <T> Future<T> submit(@NonNull Callable<T> task) {
        return this.getTarget().submit(this.instrument(task));
    }

    @Override
    @NonNull
    default public <T> Future<T> submit(@NonNull Runnable task, T result) {
        return this.getTarget().submit(this.instrument(task), result);
    }

    @Override
    @NonNull
    default public Future<?> submit(@NonNull Runnable task) {
        return this.getTarget().submit(this.instrument(task));
    }

    @Override
    @NonNull
    default public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getTarget().invokeAll(tasks.stream().map(this::instrument).collect(Collectors.toList()));
    }

    @Override
    @NonNull
    default public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return this.getTarget().invokeAll(tasks.stream().map(this::instrument).collect(Collectors.toList()), timeout, unit);
    }

    @Override
    @NonNull
    default public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getTarget().invokeAny(tasks.stream().map(this::instrument).collect(Collectors.toList()));
    }

    @Override
    @NonNull
    default public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getTarget().invokeAny(tasks.stream().map(this::instrument).collect(Collectors.toList()), timeout, unit);
    }
}

