/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.ResponseEntryBuilder;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotMvDataResponse;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ResponseEntryImpl
implements SnapshotMvDataResponse.ResponseEntry {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 13;
    @IgniteToStringInclude
    private final int commitPartitionId;
    @IgniteToStringInclude
    private final UUID commitTableId;
    @IgniteToStringInclude
    private final UUID rowId;
    @IgniteToStringInclude
    private final List<ByteBuffer> rowVersions;
    @IgniteToStringInclude
    private List<HybridTimestamp> timestamps;
    private byte[] timestampsByteArray;
    @IgniteToStringInclude
    private final UUID txId;

    private ResponseEntryImpl(int commitPartitionId, UUID commitTableId, UUID rowId, List<ByteBuffer> rowVersions, List<HybridTimestamp> timestamps, byte[] timestampsByteArray, UUID txId) {
        this.commitPartitionId = commitPartitionId;
        this.commitTableId = commitTableId;
        this.rowId = rowId;
        this.rowVersions = rowVersions;
        this.timestamps = timestamps;
        this.timestampsByteArray = timestampsByteArray;
        this.txId = txId;
    }

    @Override
    public int commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public UUID commitTableId() {
        return this.commitTableId;
    }

    @Override
    public UUID rowId() {
        return this.rowId;
    }

    @Override
    public List<ByteBuffer> rowVersions() {
        return this.rowVersions;
    }

    byte[] timestampsByteArray() {
        return this.timestampsByteArray;
    }

    @Override
    public List<HybridTimestamp> timestamps() {
        return this.timestamps;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ResponseEntryImpl.class, (Object)this);
    }

    public short messageType() {
        return 13;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResponseEntryImpl otherMessage = (ResponseEntryImpl)other;
        return Objects.equals(this.commitTableId, otherMessage.commitTableId) && Objects.equals(this.rowId, otherMessage.rowId) && Objects.equals(this.rowVersions, otherMessage.rowVersions) && Objects.equals(this.timestamps, otherMessage.timestamps) && Objects.equals(this.txId, otherMessage.txId) && this.commitPartitionId == otherMessage.commitPartitionId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commitPartitionId, this.commitTableId, this.rowId, this.rowVersions, this.timestamps, this.txId);
        return result;
    }

    public static ResponseEntryBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject timestampsByteArraymo = marshaller.marshal(this.timestamps);
        usedDescriptors.addAll((IntCollection)timestampsByteArraymo.usedDescriptorIds());
        this.timestampsByteArray = timestampsByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.timestamps = (List)marshaller.unmarshal(this.timestampsByteArray, descriptorsObj);
        this.timestampsByteArray = null;
    }

    private static class Builder
    implements ResponseEntryBuilder {
        private int commitPartitionId;
        private UUID commitTableId;
        private UUID rowId;
        private List<ByteBuffer> rowVersions;
        private List<HybridTimestamp> timestamps;
        private byte[] timestampsByteArray;
        private UUID txId;

        private Builder() {
        }

        @Override
        public ResponseEntryBuilder commitPartitionId(int commitPartitionId) {
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public ResponseEntryBuilder commitTableId(UUID commitTableId) {
            this.commitTableId = commitTableId;
            return this;
        }

        @Override
        public ResponseEntryBuilder rowId(UUID rowId) {
            this.rowId = rowId;
            return this;
        }

        @Override
        public ResponseEntryBuilder rowVersions(List<ByteBuffer> rowVersions) {
            this.rowVersions = rowVersions;
            return this;
        }

        @Override
        public ResponseEntryBuilder timestamps(List<HybridTimestamp> timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        @Override
        public ResponseEntryBuilder timestampsByteArray(byte[] timestampsByteArray) {
            this.timestampsByteArray = timestampsByteArray;
            return this;
        }

        @Override
        public ResponseEntryBuilder txId(UUID txId) {
            this.txId = txId;
            return this;
        }

        @Override
        public int commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public UUID commitTableId() {
            return this.commitTableId;
        }

        @Override
        public UUID rowId() {
            return this.rowId;
        }

        @Override
        public List<ByteBuffer> rowVersions() {
            return this.rowVersions;
        }

        @Override
        public List<HybridTimestamp> timestamps() {
            return this.timestamps;
        }

        @Override
        public byte[] timestampsByteArray() {
            return this.timestampsByteArray;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public SnapshotMvDataResponse.ResponseEntry build() {
            return new ResponseEntryImpl(this.commitPartitionId, this.commitTableId, this.rowId, this.rowVersions, this.timestamps, this.timestampsByteArray, this.txId);
        }
    }
}

