/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class NewInstanceBytecodeExpression
extends BytecodeExpression {
    private final List<BytecodeExpression> parameters;
    private final List<ParameterizedType> parameterTypes;

    NewInstanceBytecodeExpression(ParameterizedType type, Collection<ParameterizedType> parameterTypes, Collection<? extends BytecodeExpression> parameters) {
        super(type);
        this.parameterTypes = List.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.parameters = List.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock block = new BytecodeBlock().newObject(this.getType()).dup();
        for (BytecodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeConstructor(this.getType(), this.parameterTypes);
    }

    @Override
    protected String formatOneLine() {
        return "new " + this.getType().getSimpleName() + "(" + this.parameters.stream().map(BytecodeExpression::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.copyOf(this.parameters);
    }
}

