/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.GetPeersRequestBuilder;

public class GetPeersRequestImpl
implements CliRequests.GetPeersRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1011;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final boolean onlyAlive;

    private GetPeersRequestImpl(String groupId, String leaderId, boolean onlyAlive) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.onlyAlive = onlyAlive;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public boolean onlyAlive() {
        return this.onlyAlive;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(GetPeersRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1011;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetPeersRequestImpl otherMessage = (GetPeersRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && this.onlyAlive == otherMessage.onlyAlive;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.onlyAlive, this.groupId, this.leaderId);
        return result;
    }

    public static GetPeersRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetPeersRequestBuilder {
        private String groupId;
        private String leaderId;
        private boolean onlyAlive;

        private Builder() {
        }

        @Override
        public GetPeersRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public GetPeersRequestBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public GetPeersRequestBuilder onlyAlive(boolean onlyAlive) {
            this.onlyAlive = onlyAlive;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public boolean onlyAlive() {
            return this.onlyAlive;
        }

        @Override
        public CliRequests.GetPeersRequest build() {
            return new GetPeersRequestImpl(this.groupId, this.leaderId, this.onlyAlive);
        }
    }
}

