/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.index.SortedIndex;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowConverter;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.util.CompositePublisher;
import org.apache.ignite.internal.sql.engine.util.SortingCompositePublisher;
import org.apache.ignite.internal.util.ArrayUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class IndexScanNode<RowT>
extends AbstractNode<RowT> {
    private static final int NOT_WAITING = -1;
    private final IgniteIndex schemaIndex;
    private final BinaryTupleSchema indexRowSchema;
    private final RowHandler.RowFactory<RowT> factory;
    private final int[] parts;
    private final Queue<RowT> inBuff = new LinkedBlockingQueue<RowT>(512);
    @Nullable
    private final Predicate<RowT> filters;
    @Nullable
    private final Function<RowT, RowT> rowTransformer;
    private final Function<BinaryRow, RowT> tableRowConverter;
    private final ImmutableIntList idxColumnMapping;
    @Nullable
    private final BitSet requiredColumns;
    @Nullable
    private final RangeIterable<RowT> rangeConditions;
    @Nullable
    private final Comparator<RowT> comp;
    @Nullable
    private Iterator<RangeCondition<RowT>> rangeConditionIterator;
    private int requested;
    private int waiting;
    private boolean inLoop;
    private Flow.Subscription activeSubscription;
    private boolean rangeConditionsProcessed;

    public IndexScanNode(ExecutionContext<RowT> ctx, RelDataType rowType, IgniteIndex schemaIndex, InternalIgniteTable schemaTable, ImmutableIntList idxColumnMapping, int[] parts, @Nullable Comparator<RowT> comp, @Nullable RangeIterable<RowT> rangeConditions, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer, @Nullable BitSet requiredColumns) {
        super(ctx, rowType);
        assert (!ArrayUtils.nullOrEmpty((int[])parts));
        assert (this.context().transaction() != null || this.context().transactionTime() != null) : "Transaction not initialized.";
        this.schemaIndex = schemaIndex;
        this.parts = parts;
        this.filters = filters;
        this.rowTransformer = rowTransformer;
        this.requiredColumns = requiredColumns;
        this.rangeConditions = rangeConditions;
        this.idxColumnMapping = idxColumnMapping;
        this.comp = comp;
        this.rangeConditionIterator = rangeConditions == null ? null : rangeConditions.iterator();
        this.factory = ctx.rowHandler().factory(ctx.getTypeFactory(), rowType);
        this.tableRowConverter = row -> schemaTable.toRow(this.context(), (BinaryRow)row, this.factory, requiredColumns);
        this.indexRowSchema = RowConverter.createIndexRowSchema(schemaTable.descriptor(), idxColumnMapping);
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0) : "rowsCnt=" + rowsCnt + ", requested=" + this.requested;
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::push, this::onError);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.rangeConditionsProcessed = false;
        if (this.rangeConditions != null) {
            this.rangeConditionIterator = this.rangeConditions.iterator();
        }
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    private void push() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.checkState();
        if (this.requested > 0 && !this.inBuff.isEmpty()) {
            this.inLoop = true;
            try {
                while (this.requested > 0 && !this.inBuff.isEmpty()) {
                    this.checkState();
                    RowT row = this.inBuff.poll();
                    if (this.filters != null && !this.filters.test(row)) continue;
                    if (this.rowTransformer != null) {
                        row = this.rowTransformer.apply(row);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
        }
        if (this.requested > 0 && (this.waiting == 0 || this.activeSubscription == null)) {
            this.requestNextBatch();
        }
        if (this.requested > 0 && this.waiting == -1) {
            if (this.inBuff.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            } else {
                this.context().execute(this::push, this::onError);
            }
        }
    }

    private void requestNextBatch() {
        Flow.Subscription subscription;
        if (this.waiting == -1) {
            return;
        }
        if (this.waiting == 0) {
            this.waiting = 512 - this.inBuff.size();
        }
        if ((subscription = this.activeSubscription) != null) {
            subscription.request(this.waiting);
        } else if (!this.rangeConditionsProcessed) {
            RangeCondition<RowT> cond = null;
            if (this.rangeConditionIterator == null || !this.rangeConditionIterator.hasNext()) {
                this.rangeConditionsProcessed = true;
            } else {
                cond = this.rangeConditionIterator.next();
                this.rangeConditionsProcessed = !this.rangeConditionIterator.hasNext();
            }
            this.indexPublisher(this.parts, cond).subscribe(new SubscriberImpl());
        } else {
            this.waiting = -1;
        }
    }

    private Flow.Publisher<RowT> indexPublisher(int[] parts, @Nullable RangeCondition<RowT> cond) {
        ArrayList<Flow.Publisher<RowT>> partPublishers = new ArrayList<Flow.Publisher<RowT>>(parts.length);
        for (int p : parts) {
            partPublishers.add(this.partitionPublisher(p, cond));
        }
        return this.comp != null ? new SortingCompositePublisher<RowT>(partPublishers, this.comp, 100) : new CompositePublisher(partPublishers);
    }

    private Flow.Publisher<RowT> partitionPublisher(int part, @Nullable RangeCondition<RowT> cond) {
        Flow.Publisher pub;
        if (this.schemaIndex.type() == IgniteIndex.Type.SORTED) {
            int flags = 0;
            BinaryTuplePrefix lower = null;
            BinaryTuplePrefix upper = null;
            if (cond == null) {
                flags = 3;
            } else {
                lower = this.toBinaryTuplePrefix(cond.lower());
                upper = this.toBinaryTuplePrefix(cond.upper());
                flags |= cond.lowerInclude() ? 1 : 0;
                flags |= cond.upperInclude() ? 2 : 0;
            }
            pub = ((SortedIndex)this.schemaIndex.index()).scan(part, this.context().transaction(), lower, upper, flags, this.requiredColumns);
        } else {
            assert (this.schemaIndex.type() == IgniteIndex.Type.HASH);
            BinaryTuple key = null;
            if (cond != null) {
                key = this.toBinaryTuple(cond.lower());
            }
            pub = this.schemaIndex.index().lookup(part, this.context().transaction(), key, this.requiredColumns);
        }
        return downstream -> {
            Flow.Subscriber<BinaryRow> subs = new Flow.Subscriber<BinaryRow>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    downstream.onSubscribe(subscription);
                }

                @Override
                public void onNext(BinaryRow item) {
                    downstream.onNext(IndexScanNode.this.convert(item));
                }

                @Override
                public void onError(Throwable throwable) {
                    downstream.onError(throwable);
                }

                @Override
                public void onComplete() {
                    downstream.onComplete();
                }
            };
            pub.subscribe(subs);
        };
    }

    @Contract(value="null -> null")
    @Nullable
    private BinaryTuplePrefix toBinaryTuplePrefix(@Nullable RowT condition) {
        if (condition == null) {
            return null;
        }
        return RowConverter.toBinaryTuplePrefix(this.context(), this.indexRowSchema, this.idxColumnMapping, this.factory, condition);
    }

    @Contract(value="null -> null")
    @Nullable
    private BinaryTuple toBinaryTuple(@Nullable RowT condition) {
        if (condition == null) {
            return null;
        }
        return RowConverter.toBinaryTuple(this.context(), this.indexRowSchema, this.idxColumnMapping, this.factory, condition);
    }

    private RowT convert(BinaryRow binaryRow) {
        return this.tableRowConverter.apply(binaryRow);
    }

    private class SubscriberImpl
    implements Flow.Subscriber<RowT> {
        private SubscriberImpl() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            assert (IndexScanNode.this.activeSubscription == null);
            IndexScanNode.this.activeSubscription = subscription;
            subscription.request(IndexScanNode.this.waiting);
        }

        @Override
        public void onNext(RowT row) {
            IndexScanNode.this.inBuff.add(row);
            if (IndexScanNode.this.inBuff.size() == 512) {
                IndexScanNode.this.context().execute(() -> {
                    IndexScanNode.this.waiting = 0;
                    IndexScanNode.this.push();
                }, IndexScanNode.this::onError);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            IndexScanNode.this.context().execute(() -> {
                throw throwable;
            }, IndexScanNode.this::onError);
        }

        @Override
        public void onComplete() {
            IndexScanNode.this.context().execute(() -> {
                IndexScanNode.this.activeSubscription = null;
                IndexScanNode.this.waiting = 0;
                IndexScanNode.this.push();
            }, IndexScanNode.this::onError);
        }
    }
}

