/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.client.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.shaded.org.apache.ignite.internal.streamer.StreamerPartitionAwarenessProvider;

abstract class AbstractClientStreamerPartitionAwarenessProvider<T>
implements StreamerPartitionAwarenessProvider<T, Integer> {
    private final ClientTable tbl;
    private volatile int partitions = -1;
    private volatile ClientSchema schema;

    AbstractClientStreamerPartitionAwarenessProvider(ClientTable tbl) {
        this.tbl = tbl;
    }

    @Override
    public Integer partition(T item) {
        ClientSchema schema0 = this.schema;
        int partitions0 = this.partitions;
        if (schema0 == null || partitions0 < 0) {
            throw new IllegalStateException("StreamerPartitionAwarenessProvider.refreshAsync() was not called or awaited.");
        }
        if (partitions0 == 0) {
            throw new IllegalStateException("StreamerPartitionAwarenessProvider has zero partitions.");
        }
        int hash = this.colocationHash(schema0, item);
        return Math.abs(hash % partitions0);
    }

    abstract int colocationHash(ClientSchema var1, T var2);

    @Override
    public CompletableFuture<Void> refreshAsync() {
        CompletionStage schemaFut = this.tbl.getLatestSchema().thenAccept(schema -> {
            this.schema = schema;
        });
        if (this.partitions < 0) {
            this.partitions = this.tbl.tryGetPartitionCount();
        }
        if (this.partitions > 0) {
            return schemaFut;
        }
        CompletionStage assignmentFut = this.tbl.getPartitionAssignment().thenAccept(assignment -> {
            this.partitions = assignment.size();
        });
        return CompletableFuture.allOf(new CompletableFuture[]{schemaFut, assignmentFut});
    }
}

