/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;

public abstract class AbstractStripedThreadPoolExecutor<E extends ExecutorService>
implements ExecutorService {
    private final E[] execs;
    private final Random random = new Random();

    public AbstractStripedThreadPoolExecutor(E[] execs) {
        this.execs = execs;
    }

    public void execute(Runnable task, int idx) {
        this.stripeExecutor(idx).execute(task);
    }

    @Override
    public void execute(Runnable task) {
        this.stripeExecutor(this.random.nextInt(this.execs.length)).execute(task);
    }

    public CompletableFuture<?> submit(Runnable task, int idx) {
        return CompletableFuture.runAsync(task, this.stripeExecutor(idx));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T res) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        for (E exec : this.execs) {
            exec.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.execs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> res = new ArrayList<Runnable>(this.execs.length);
        for (E exec : this.execs) {
            res.addAll(exec.shutdownNow());
        }
        return res;
    }

    @Override
    public boolean isShutdown() {
        for (E exec : this.execs) {
            if (exec.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (E exec : this.execs) {
            if (exec.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean res = true;
        for (E exec : this.execs) {
            res &= exec.awaitTermination(timeout, unit);
        }
        return res;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(AbstractStripedThreadPoolExecutor.class, this);
    }

    public E stripeExecutor(int idx) {
        return this.execs[this.threadId(idx)];
    }

    public int concurrencyLevel() {
        return this.execs.length;
    }

    private int threadId(int idx) {
        assert (idx >= 0) : "Index is negative: " + idx;
        return idx < this.execs.length ? idx : idx % this.execs.length;
    }
}

