/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.tostring;

import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.IgniteToStringOrder;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.Stringifier;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.ToStringUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

class FieldDescriptor {
    static final int FIELD_TYPE_OBJECT = 0;
    static final int FIELD_TYPE_BYTE = 1;
    static final int FIELD_TYPE_BOOLEAN = 2;
    static final int FIELD_TYPE_CHAR = 3;
    static final int FIELD_TYPE_SHORT = 4;
    static final int FIELD_TYPE_INT = 5;
    static final int FIELD_TYPE_FLOAT = 6;
    static final int FIELD_TYPE_LONG = 7;
    static final int FIELD_TYPE_DOUBLE = 8;
    private final String name;
    private final int order;
    private final VarHandle varHandle;
    private final int type;
    private final Class<?> cls;
    @Nullable
    private final Stringifier<?> stringifier;

    FieldDescriptor(Field field, VarHandle varHandle) {
        assert (!Modifier.isStatic(field.getModifiers())) : "Static fields are not allowed here: " + String.valueOf(field);
        this.varHandle = varHandle;
        this.cls = field.getType();
        this.order = FieldDescriptor.getFieldOrder(field);
        IgniteStringifier igniteStringifier = field.getAnnotation(IgniteStringifier.class);
        if (igniteStringifier == null) {
            this.name = field.getName();
            this.type = FieldDescriptor.getIntFieldType(field);
            this.stringifier = null;
        } else {
            this.name = "".equals(igniteStringifier.name()) ? field.getName() : igniteStringifier.name();
            this.type = 0;
            this.stringifier = ToStringUtils.createStringifier(igniteStringifier.value());
        }
    }

    int getOrder() {
        return this.order;
    }

    VarHandle varHandle() {
        return this.varHandle;
    }

    int type() {
        return this.type;
    }

    Class<?> fieldClass() {
        return this.cls;
    }

    String getName() {
        return this.name;
    }

    @Nullable
    Stringifier<?> stringifier() {
        return this.stringifier;
    }

    private static int getIntFieldType(Field field) {
        Class<?> cls = field.getType();
        if (!cls.isPrimitive()) {
            return 0;
        }
        if (cls == Byte.TYPE) {
            return 1;
        }
        if (cls == Boolean.TYPE) {
            return 2;
        }
        if (cls == Character.TYPE) {
            return 3;
        }
        if (cls == Short.TYPE) {
            return 4;
        }
        if (cls == Integer.TYPE) {
            return 5;
        }
        if (cls == Float.TYPE) {
            return 6;
        }
        if (cls == Long.TYPE) {
            return 7;
        }
        if (cls == Double.TYPE) {
            return 8;
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf(field));
    }

    private static int getFieldOrder(Field field) {
        IgniteToStringOrder annotation = field.getAnnotation(IgniteToStringOrder.class);
        return annotation == null ? Integer.MAX_VALUE : annotation.value();
    }
}

