/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.security.authentication.AuthenticationMode;
import io.micronaut.security.config.AuthenticationStrategy;
import io.micronaut.security.config.InterceptUrlMapPattern;
import io.micronaut.security.config.SecurityConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ConfigurationProperties(value="micronaut.security")
public class SecurityConfigurationProperties
implements SecurityConfiguration {
    public static final String PREFIX = "micronaut.security";
    public static final String ANYWHERE = "0.0.0.0";
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_INTERCEPT_URL_MAP_PREPEND_PATTERN_WITH_CONTEXT_PATH = false;
    public static final AuthenticationStrategy DEFAULT_AUTHENTICATION_STRATEGY = AuthenticationStrategy.ANY;
    public static final boolean DEFAULT_REJECT_NOT_FOUND = true;
    private boolean enabled = true;
    private boolean interceptUrlMapPrependPatternWithContextPath = false;
    private List<InterceptUrlMapPattern> interceptUrlMap = new ArrayList<InterceptUrlMapPattern>();
    private List<String> ipPatterns = Collections.singletonList("0.0.0.0");
    private AuthenticationStrategy authenticationProviderStrategy = DEFAULT_AUTHENTICATION_STRATEGY;
    private boolean rejectNotFound = true;
    @Nullable
    private AuthenticationMode authentication = null;

    @Override
    @Nullable
    public AuthenticationMode getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(@Nullable AuthenticationMode authentication) {
        this.authentication = authentication;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<InterceptUrlMapPattern> getInterceptUrlMap() {
        return this.interceptUrlMap;
    }

    @Override
    public List<String> getIpPatterns() {
        return this.ipPatterns;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isInterceptUrlMapPrependPatternWithContextPath() {
        return this.interceptUrlMapPrependPatternWithContextPath;
    }

    public void setInterceptUrlMapPrependPatternWithContextPath(boolean interceptUrlMapPrependPatternWithContextPath) {
        this.interceptUrlMapPrependPatternWithContextPath = interceptUrlMapPrependPatternWithContextPath;
    }

    public void setInterceptUrlMap(List<InterceptUrlMapPattern> interceptUrlMap) {
        if (CollectionUtils.isNotEmpty(interceptUrlMap)) {
            this.interceptUrlMap = interceptUrlMap;
        }
    }

    public void setIpPatterns(List<String> ipPatterns) {
        this.ipPatterns = ipPatterns;
    }

    @Override
    public AuthenticationStrategy getAuthenticationProviderStrategy() {
        return this.authenticationProviderStrategy;
    }

    public void setAuthenticationProviderStrategy(AuthenticationStrategy authenticationProviderStrategy) {
        this.authenticationProviderStrategy = authenticationProviderStrategy;
    }

    @Override
    public boolean isRejectNotFound() {
        return this.rejectNotFound;
    }

    public void setRejectNotFound(boolean rejectNotFound) {
        this.rejectNotFound = rejectNotFound;
    }
}

