/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingIgniteCluster
implements IgniteCluster,
Wrapper {
    private final IgniteCluster cluster;

    public PublicApiThreadingIgniteCluster(IgniteCluster cluster) {
        this.cluster = cluster;
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.cluster);
    }

    public UUID id() {
        return (UUID)PublicApiThreading.execUserSyncOperation(() -> ((IgniteCluster)this.cluster).id());
    }

    public Collection<ClusterNode> nodes() {
        return (Collection)PublicApiThreading.execUserSyncOperation(() -> ((IgniteCluster)this.cluster).nodes());
    }

    public CompletableFuture<Collection<ClusterNode>> nodesAsync() {
        return CompletableFuture.completedFuture(this.nodes());
    }

    @Nullable
    public ClusterNode localNode() {
        return (ClusterNode)PublicApiThreading.execUserSyncOperation(() -> ((IgniteCluster)this.cluster).localNode());
    }
}

