/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.CompactionCommand;
import org.apache.ignite.internal.metastorage.command.CompactionCommandBuilder;
import org.apache.ignite.internal.metastorage.command.CompactionCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class CompactionCommandImpl
implements CompactionCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 72;
    @IgniteToStringInclude
    private final long compactionRevision;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private CompactionCommandImpl(long compactionRevision, HybridTimestamp initiatorTime, HybridTimestamp safeTime) {
        this.compactionRevision = compactionRevision;
        this.initiatorTime = initiatorTime;
        this.safeTime = safeTime;
    }

    @Override
    public long compactionRevision() {
        return this.compactionRevision;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return CompactionCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(CompactionCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 72;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CompactionCommandImpl otherMessage = (CompactionCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime) && this.compactionRevision == otherMessage.compactionRevision;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.compactionRevision, this.initiatorTime, this.safeTime);
        return result;
    }

    public CompactionCommandImpl clone() {
        try {
            return (CompactionCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CompactionCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements CompactionCommandBuilder {
        private long compactionRevision;
        private HybridTimestamp initiatorTime;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public CompactionCommandBuilder compactionRevision(long compactionRevision) {
            this.compactionRevision = compactionRevision;
            return this;
        }

        @Override
        public CompactionCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public CompactionCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public long compactionRevision() {
            return this.compactionRevision;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public CompactionCommand build() {
            return new CompactionCommandImpl(this.compactionRevision, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.safeTime);
        }
    }
}

