/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.PutAllCommand;
import org.apache.ignite.internal.metastorage.command.PutAllCommandBuilder;
import org.apache.ignite.internal.metastorage.command.PutAllCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tostring.SizeOnlyStringifier;

public class PutAllCommandImpl
implements PutAllCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 50;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteStringifier(name="keys.size", value=SizeOnlyStringifier.class)
    private final List<ByteBuffer> keys;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteStringifier(name="values.size", value=SizeOnlyStringifier.class)
    private final List<ByteBuffer> values;

    private PutAllCommandImpl(HybridTimestamp initiatorTime, List<ByteBuffer> keys, HybridTimestamp safeTime, List<ByteBuffer> values) {
        this.initiatorTime = initiatorTime;
        this.keys = keys;
        this.safeTime = safeTime;
        this.values = values;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public List<ByteBuffer> keys() {
        return this.keys;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public List<ByteBuffer> values() {
        return this.values;
    }

    public MessageSerializer serializer() {
        return PutAllCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(PutAllCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 50;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PutAllCommandImpl otherMessage = (PutAllCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.keys, otherMessage.keys) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.values, otherMessage.values);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.initiatorTime, this.keys, this.safeTime, this.values);
        return result;
    }

    public PutAllCommandImpl clone() {
        try {
            return (PutAllCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PutAllCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements PutAllCommandBuilder {
        private HybridTimestamp initiatorTime;
        private List<ByteBuffer> keys;
        private HybridTimestamp safeTime;
        private List<ByteBuffer> values;

        private Builder() {
        }

        @Override
        public PutAllCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public PutAllCommandBuilder keys(List<ByteBuffer> keys) {
            Objects.requireNonNull(keys, "keys is not marked @Nullable");
            this.keys = keys;
            return this;
        }

        @Override
        public PutAllCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public PutAllCommandBuilder values(List<ByteBuffer> values) {
            Objects.requireNonNull(values, "values is not marked @Nullable");
            this.values = values;
            return this;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public List<ByteBuffer> keys() {
            return this.keys;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public List<ByteBuffer> values() {
            return this.values;
        }

        @Override
        public PutAllCommand build() {
            return new PutAllCommandImpl(Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), Objects.requireNonNull(this.keys, "keys is not marked @Nullable"), this.safeTime, Objects.requireNonNull(this.values, "values is not marked @Nullable"));
        }
    }
}

