/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.metastore;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.FileDeployerService;
import org.apache.ignite.internal.deployunit.metastore.ClusterEventCallback;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.status.UnitClusterStatus;
import org.apache.ignite.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite.internal.network.ClusterNodeImpl;

public class ClusterEventCallbackImpl
extends ClusterEventCallback {
    private final DeploymentUnitStore deploymentUnitStore;
    private final FileDeployerService deployerService;
    private final ClusterManagementGroupManager cmgManager;
    private final String nodeName;

    public ClusterEventCallbackImpl(DeploymentUnitStore deploymentUnitStore, FileDeployerService deployerService, ClusterManagementGroupManager cmgManager, String nodeName) {
        this.deploymentUnitStore = deploymentUnitStore;
        this.deployerService = deployerService;
        this.cmgManager = cmgManager;
        this.nodeName = nodeName;
    }

    @Override
    public void onRemoving(UnitClusterStatus status) {
        String id = status.id();
        Version version = status.version();
        this.deploymentUnitStore.getNodeStatus(this.nodeName, id, version).thenAccept(nodeStatus -> {
            if (nodeStatus != null && nodeStatus.status() == DeploymentStatus.REMOVING) {
                this.undeploy(id, version, nodeStatus.opId());
            }
        });
    }

    private void undeploy(String id, Version version, UUID opId) {
        this.deployerService.undeploy(id, version).thenAccept(success -> {
            if (success.booleanValue()) {
                this.deploymentUnitStore.removeNodeStatus(this.nodeName, id, version, opId).thenAccept(successRemove -> {
                    if (successRemove.booleanValue()) {
                        this.removeClusterStatus(id, version, opId);
                    }
                });
            }
        });
    }

    private void removeClusterStatus(String id, Version version, UUID opId) {
        this.cmgManager.logicalTopology().thenAccept(logicalTopology -> {
            Set logicalNodes = logicalTopology.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
            this.deploymentUnitStore.getAllNodeStatuses(id, version).thenAccept(statuses -> {
                boolean emptyTopology = statuses.stream().map(UnitNodeStatus::nodeId).filter(logicalNodes::contains).findAny().isEmpty();
                if (emptyTopology) {
                    this.deploymentUnitStore.removeClusterStatus(id, version, opId);
                }
            });
        });
    }
}

