/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.sorted;

import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite.internal.pagememory.tree.IgniteTree;
import org.apache.ignite.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.jetbrains.annotations.Nullable;

class InsertSortedIndexRowInvokeClosure
implements IgniteTree.InvokeClosure<SortedIndexRow> {
    private final SortedIndexRow sortedIndexRow;
    private final FreeListImpl freeList;
    private IgniteTree.OperationType operationType = IgniteTree.OperationType.PUT;
    private final int inlineSize;

    public InsertSortedIndexRowInvokeClosure(SortedIndexRow sortedIndexRow, FreeListImpl freeList, int inlineSize) {
        assert (sortedIndexRow.indexColumns().link() == 0L);
        this.sortedIndexRow = sortedIndexRow;
        this.freeList = freeList;
        this.inlineSize = inlineSize;
    }

    public void call(@Nullable SortedIndexRow oldRow) throws IgniteInternalCheckedException {
        if (oldRow != null) {
            this.operationType = IgniteTree.OperationType.NOOP;
            return;
        }
        if (!InlineUtils.canFullyInline(this.sortedIndexRow.indexColumns().valueSize(), this.inlineSize)) {
            this.freeList.insertDataRow((Storable)this.sortedIndexRow.indexColumns());
        }
    }

    @Nullable
    public SortedIndexRow newRow() {
        return this.sortedIndexRow;
    }

    public IgniteTree.OperationType operationType() {
        return this.operationType;
    }
}

