/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;

public class ReplicaMessageUtils {
    public static TablePartitionIdMessage toTablePartitionIdMessage(ReplicaMessagesFactory messagesFactory, TablePartitionId tablePartitionId) {
        return messagesFactory.tablePartitionIdMessage().tableId(tablePartitionId.tableId()).partitionId(tablePartitionId.partitionId()).build();
    }

    public static ZonePartitionIdMessage toZonePartitionIdMessage(ReplicaMessagesFactory messagesFactory, ZonePartitionId zonePartitionId) {
        return messagesFactory.zonePartitionIdMessage().zoneId(zonePartitionId.zoneId()).partitionId(zonePartitionId.partitionId()).build();
    }

    public static ReplicationGroupIdMessage toReplicationGroupIdMessage(ReplicaMessagesFactory messagesFactory, ReplicationGroupId replicationGroupId) {
        assert (replicationGroupId instanceof TablePartitionId || replicationGroupId instanceof ZonePartitionId) : "Unexpected type of replication group identifier [class=" + replicationGroupId.getClass().getSimpleName() + ", value=" + String.valueOf(replicationGroupId) + ", requiredType=TablePartitionId or ZonePartitionId].";
        if (replicationGroupId instanceof TablePartitionId) {
            return ReplicaMessageUtils.toTablePartitionIdMessage(messagesFactory, (TablePartitionId)replicationGroupId);
        }
        return ReplicaMessageUtils.toZonePartitionIdMessage(messagesFactory, (ZonePartitionId)replicationGroupId);
    }
}

