/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SequenceIdCollector {
    private final TreeMap<Long, Long> processedInterval = new TreeMap();

    private static boolean isInClosedRange(Map.Entry<Long, Long> range, long element) {
        return range != null && range.getKey() <= element && element <= range.getValue();
    }

    private static boolean isNextToClosedRange(Map.Entry<Long, Long> range, long element) {
        return range != null && (element + 1L == range.getKey() || element - 1L == range.getValue());
    }

    public boolean contains(long sequenceId) {
        return SequenceIdCollector.isInClosedRange(this.processedInterval.floorEntry(sequenceId), sequenceId);
    }

    public boolean add(long sequenceId) {
        Map.Entry<Long, Long> floorEntry = this.processedInterval.floorEntry(sequenceId);
        if (SequenceIdCollector.isInClosedRange(floorEntry, sequenceId)) {
            return false;
        }
        Map.Entry<Long, Long> ceilingEntry = this.processedInterval.ceilingEntry(sequenceId);
        boolean nextToFloor = SequenceIdCollector.isNextToClosedRange(floorEntry, sequenceId);
        boolean nextToCeiling = SequenceIdCollector.isNextToClosedRange(ceilingEntry, sequenceId);
        if (nextToFloor && nextToCeiling) {
            this.processedInterval.remove(floorEntry.getKey());
            this.processedInterval.remove(ceilingEntry.getKey());
            this.processedInterval.put(floorEntry.getKey(), ceilingEntry.getValue());
        } else if (nextToFloor) {
            this.processedInterval.remove(floorEntry.getKey());
            this.processedInterval.put(floorEntry.getKey(), sequenceId);
        } else if (nextToCeiling) {
            this.processedInterval.remove(ceilingEntry.getKey());
            this.processedInterval.put(sequenceId, ceilingEntry.getValue());
        } else {
            this.processedInterval.put(sequenceId, sequenceId);
        }
        return true;
    }

    public int size() {
        return this.processedInterval.size();
    }

    public void clear() {
        this.processedInterval.clear();
    }

    public String toString() {
        return this.processedInterval.entrySet().stream().map(entry -> "[" + entry.getKey() + "," + entry.getValue() + "]").collect(Collectors.joining(",", "{", "}"));
    }
}

