/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.configuration;

import java.util.function.IntSupplier;
import java.util.function.LongSupplier;

public class CheckpointConfiguration {
    public static final int DEFAULT_CHECKPOINT_THREADS = 4;
    public static final int DEFAULT_COMPACTION_THREADS = 4;
    public static final long DEFAULT_CHECKPOINT_INTERVAL = 180000L;
    public static final int DEFAULT_CHECKPOINT_INTERVAL_DEVIATION = 40;
    public static final int DEFAULT_CHECKPOINT_READ_LOCK_TIMEOUT = 10000;
    public static final int DEFAULT_CHECKPOINT_LOG_READ_LOCK_THRESHOLD_TIMEOUT = 0;
    private final int checkpointThreads;
    private final int compactionThreads;
    private final LongSupplier intervalMillis;
    private final IntSupplier intervalDeviationPercent;
    private final LongSupplier readLockTimeoutMillis;
    private final LongSupplier logReadLockThresholdTimeoutMillis;

    private CheckpointConfiguration(int checkpointThreads, int compactionThreads, LongSupplier intervalMillis, IntSupplier intervalDeviationPercent, LongSupplier readLockTimeoutMillis, LongSupplier logReadLockThresholdTimeoutMillis) {
        this.checkpointThreads = checkpointThreads;
        this.compactionThreads = compactionThreads;
        this.intervalMillis = intervalMillis;
        this.intervalDeviationPercent = intervalDeviationPercent;
        this.readLockTimeoutMillis = readLockTimeoutMillis;
        this.logReadLockThresholdTimeoutMillis = logReadLockThresholdTimeoutMillis;
    }

    public int checkpointThreads() {
        return this.checkpointThreads;
    }

    public int compactionThreads() {
        return this.compactionThreads;
    }

    public long intervalMillis() {
        return this.intervalMillis.getAsLong();
    }

    public int intervalDeviationPercent() {
        return this.intervalDeviationPercent.getAsInt();
    }

    public long readLockTimeoutMillis() {
        return this.readLockTimeoutMillis.getAsLong();
    }

    public long logReadLockThresholdTimeoutMillis() {
        return this.logReadLockThresholdTimeoutMillis.getAsLong();
    }

    public static CheckpointConfigurationBuilder builder() {
        return new CheckpointConfigurationBuilder();
    }

    public static final class CheckpointConfigurationBuilder {
        private int checkpointThreads = 4;
        private int compactionThreads = 4;
        private LongSupplier intervalMillis = () -> 180000L;
        private IntSupplier intervalDeviationPercent = () -> 40;
        private LongSupplier readLockTimeoutMillis = () -> 10000L;
        private LongSupplier logReadLockThresholdTimeoutMillis = () -> 0L;

        CheckpointConfigurationBuilder() {
        }

        public CheckpointConfigurationBuilder checkpointThreads(int checkpointThreads) {
            this.checkpointThreads = checkpointThreads;
            return this;
        }

        public CheckpointConfigurationBuilder compactionThreads(int compactionThreads) {
            this.compactionThreads = compactionThreads;
            return this;
        }

        public CheckpointConfigurationBuilder intervalMillis(LongSupplier intervalMillis) {
            this.intervalMillis = intervalMillis;
            return this;
        }

        public CheckpointConfigurationBuilder intervalDeviationPercent(IntSupplier intervalDeviationPercent) {
            this.intervalDeviationPercent = intervalDeviationPercent;
            return this;
        }

        public CheckpointConfigurationBuilder readLockTimeoutMillis(LongSupplier readLockTimeoutMillis) {
            this.readLockTimeoutMillis = readLockTimeoutMillis;
            return this;
        }

        public CheckpointConfigurationBuilder logReadLockThresholdTimeoutMillis(LongSupplier logReadLockThresholdTimeoutMillis) {
            this.logReadLockThresholdTimeoutMillis = logReadLockThresholdTimeoutMillis;
            return this;
        }

        public CheckpointConfiguration build() {
            return new CheckpointConfiguration(this.checkpointThreads, this.compactionThreads, this.intervalMillis, this.intervalDeviationPercent, this.readLockTimeoutMillis, this.logReadLockThresholdTimeoutMillis);
        }
    }
}

