/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.impl;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite.internal.eventlog.api.Event;
import org.apache.ignite.internal.eventlog.api.EventChannel;
import org.apache.ignite.internal.eventlog.api.EventLog;
import org.apache.ignite.internal.eventlog.config.schema.EventLogConfiguration;
import org.apache.ignite.internal.eventlog.impl.ChannelRegistry;
import org.apache.ignite.internal.eventlog.impl.ConfigurationBasedChannelRegistry;
import org.apache.ignite.internal.eventlog.impl.ConfigurationBasedSinkRegistry;
import org.apache.ignite.internal.eventlog.impl.SinkFactory;
import org.apache.ignite.internal.eventlog.impl.SinkFactoryImpl;
import org.apache.ignite.internal.eventlog.ser.EventSerializerFactory;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.CompletableFutures;

public class EventLogImpl
implements EventLog,
IgniteComponent {
    private final ChannelRegistry channelRegistry;

    EventLogImpl(ChannelRegistry channelRegistry) {
        this.channelRegistry = channelRegistry;
    }

    public EventLogImpl(EventLogConfiguration cfg, Supplier<UUID> clusterIdSupplier, String nodeName) {
        this(cfg, new SinkFactoryImpl(new EventSerializerFactory().createEventSerializer(), clusterIdSupplier, nodeName));
    }

    EventLogImpl(EventLogConfiguration cfg, SinkFactory sinkFactory) {
        this(new ConfigurationBasedChannelRegistry(cfg, new ConfigurationBasedSinkRegistry(cfg, sinkFactory)));
    }

    @Override
    public void log(Event event) {
        Set<EventChannel> channel = this.channelRegistry.findAllChannelsByEventType(event.getType());
        if (channel == null) {
            return;
        }
        channel.forEach(c -> c.log(event));
    }

    @Override
    public void log(String type, Supplier<Event> eventProvider) {
        Set<EventChannel> channels = this.channelRegistry.findAllChannelsByEventType(type);
        if (channels == null) {
            return;
        }
        Event event = eventProvider.get();
        if (!event.getType().equals(type)) {
            throw new IllegalArgumentException("Event type mismatch: " + event.getType() + " != " + type);
        }
        channels.forEach(c -> c.log(event));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.channelRegistry.start();
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.channelRegistry.stop();
        return CompletableFutures.nullCompletedFuture();
    }
}

