/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.tx.IgniteTransactions;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;

class RestartProofIgniteTransactions
implements IgniteTransactions,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteTransactions(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    public Transaction begin(@Nullable TransactionOptions options) {
        return this.attachmentLock.attached(ignite -> ignite.transactions().begin(options));
    }

    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions options) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.transactions().beginAsync(options));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap((Object)ignite.transactions(), (Class)classToUnwrap));
    }
}

