/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Collection;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.RemovePeerResponseBuilder;

class RemovePeerResponseDeserializer
implements MessageDeserializer<CliRequests.RemovePeerResponse> {
    private final RemovePeerResponseBuilder msg;

    RemovePeerResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.removePeerResponse();
    }

    public Class<CliRequests.RemovePeerResponse> klass() {
        return CliRequests.RemovePeerResponse.class;
    }

    public CliRequests.RemovePeerResponse getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Collection tmp = reader.readCollection("newPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.newPeersList(tmp);
                reader.incrementState();
            }
            case 1: {
                Collection tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldPeersList(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CliRequests.RemovePeerResponse.class);
    }
}

