/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RetryAgainException;
import org.apache.ignite.raft.jraft.rpc.GetFileResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.storage.io.FileReader;
import org.apache.ignite.raft.jraft.util.ByteBufferCollector;
import org.apache.ignite.raft.jraft.util.OnlyForTest;
import org.apache.ignite.raft.jraft.util.Utils;

public final class FileService {
    private static final IgniteLogger LOG = Loggers.forClass(FileService.class);
    private static final FileService INSTANCE = new FileService(new RaftMessagesFactory());
    private final ConcurrentMap<Long, FileReader> fileReaderMap = new ConcurrentHashMap<Long, FileReader>();
    private final AtomicLong nextId = new AtomicLong();
    private final RaftMessagesFactory msgFactory;

    public static FileService getInstance() {
        return INSTANCE;
    }

    @OnlyForTest
    void clear() {
        this.fileReaderMap.clear();
    }

    private FileService(RaftMessagesFactory msgFactory) {
        long processId = Utils.getProcessId(ThreadLocalRandom.current().nextLong(10000L, Integer.MAX_VALUE));
        long initialValue = Math.abs(processId << 45 | System.nanoTime() << 17 >> 17);
        this.nextId.set(initialValue);
        LOG.info("Initial file reader id in FileService is {}", new Object[]{initialValue});
        this.msgFactory = msgFactory;
    }

    public Message handleGetFile(RpcRequests.GetFileRequest request, RpcRequestClosure done) {
        if (request.count() <= 0L || request.offset() < 0L) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EREQUEST, "Invalid request: %s", request);
        }
        FileReader reader = (FileReader)this.fileReaderMap.get(request.readerId());
        if (LOG.isDebugEnabled()) {
            LOG.info("handleGetFile id={}, name={}, offset={}, cnt={}", new Object[]{request.readerId(), request.filename(), request.offset(), request.count()});
        }
        if (reader == null) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.ENOENT, "Fail to find reader=%d", request.readerId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("GetFile from {} path={} filename={} offset={} count={}", new Object[]{done.getRpcCtx().getRemoteAddress(), reader.getPath(), request.filename(), request.offset(), request.count()});
        }
        ByteBufferCollector dataBuffer = ByteBufferCollector.allocate();
        GetFileResponseBuilder responseBuilder = this.msgFactory.getFileResponse();
        try {
            int read = reader.readFile(dataBuffer, request.filename(), request.offset(), request.count());
            responseBuilder.readSize(read);
            responseBuilder.eof(read == -1);
            ByteBuffer buf = dataBuffer.getBuffer();
            buf.flip();
            if (!buf.hasRemaining()) {
                responseBuilder.data(ArrayUtils.EMPTY_BYTE_BUFFER);
            } else {
                responseBuilder.data(buf);
            }
            return responseBuilder.build();
        }
        catch (RetryAgainException e) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EAGAIN, "Fail to read from path=%s filename=%s with error: %s", reader.getPath(), request.filename(), e.getMessage());
        }
        catch (IOException e) {
            LOG.error("Fail to read file path={} filename={}", (Throwable)e, new Object[]{reader.getPath(), request.filename()});
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EIO, "Fail to read from path=%s filename=%s", reader.getPath(), request.filename());
        }
    }

    public long addReader(FileReader reader) {
        long readerId = this.nextId.getAndIncrement();
        if (this.fileReaderMap.putIfAbsent(readerId, reader) == null) {
            return readerId;
        }
        return -1L;
    }

    public boolean removeReader(long readerId) {
        return this.fileReaderMap.remove(readerId) != null;
    }
}

