/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.streamer.StreamerOptions;
import org.apache.ignite.internal.streamer.StreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.streamer.StreamerSubscriber;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOperationType;
import org.apache.ignite.table.DataStreamerOptions;
import org.jetbrains.annotations.Nullable;

class DataStreamer {
    private static final IgniteLogger LOG = Loggers.forClass(DataStreamer.class);

    DataStreamer() {
    }

    static <R> CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options, StreamerBatchSender<R, Integer, Void> batchSender, StreamerPartitionAwarenessProvider<R, Integer> partitionAwarenessProvider, ScheduledExecutorService flushExecutor) {
        return DataStreamer.streamData(publisher, DataStreamerItem::get, DataStreamerItem::get, x -> x.operationType() == DataStreamerOperationType.REMOVE, options, batchSender, null, partitionAwarenessProvider, flushExecutor);
    }

    static <T, E, V, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, T> keyFunc, Function<E, V> payloadFunc, Function<E, Boolean> deleteFunc, @Nullable DataStreamerOptions options, StreamerBatchSender<V, Integer, R> batchSender, @Nullable Flow.Subscriber<R> resultSubscriber, StreamerPartitionAwarenessProvider<T, Integer> partitionAwarenessProvider, ScheduledExecutorService flushExecutor) {
        StreamerOptions streamerOpts = DataStreamer.streamerOptions(options);
        StreamerSubscriber subscriber = new StreamerSubscriber(batchSender, resultSubscriber, keyFunc, payloadFunc, deleteFunc, partitionAwarenessProvider, streamerOpts, flushExecutor, LOG, null);
        publisher.subscribe((Flow.Subscriber<E>)subscriber);
        return subscriber.completionFuture();
    }

    private static StreamerOptions streamerOptions(@Nullable DataStreamerOptions options) {
        final DataStreamerOptions options0 = options == null ? DataStreamerOptions.DEFAULT : options;
        return new StreamerOptions(){

            public int pageSize() {
                return options0.pageSize();
            }

            public int perPartitionParallelOperations() {
                return options0.perPartitionParallelOperations();
            }

            public int autoFlushInterval() {
                return options0.autoFlushInterval();
            }
        };
    }
}

