/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.DataStreamer;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.KeyValueTupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.table.TableRow;
import org.apache.ignite.internal.table.TupleMarshallerCache;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class KeyValueBinaryViewImpl
extends AbstractTableView<Map.Entry<Tuple, Tuple>>
implements KeyValueView<Tuple, Tuple> {
    private final TupleMarshallerCache marshallerCache;

    public KeyValueBinaryViewImpl(InternalTable tbl, SchemaRegistry schemaReg, SchemaVersions schemaVersions, IgniteSql sql, MarshallersProvider marshallers) {
        super(tbl, schemaVersions, schemaReg, sql, marshallers);
        this.marshallerCache = new TupleMarshallerCache(schemaReg);
    }

    public Tuple get(@Nullable Transaction tx, Tuple key) {
        return (Tuple)ViewUtils.sync(this.getAsync(tx, key));
    }

    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            Row keyRow = this.marshal(key, null, schemaVersion);
            return this.tbl.get((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(row -> this.unmarshalValue((BinaryRow)row, schemaVersion));
        });
    }

    public NullableValue<Tuple> getNullable(@Nullable Transaction tx, Tuple key) {
        return (NullableValue)ViewUtils.sync(this.getNullableAsync(tx, key));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAsync(@Nullable Transaction tx, Tuple key) {
        return this.getAsync(tx, key).thenApply(r -> r == null ? null : NullableValue.of((Object)r));
    }

    public Tuple getOrDefault(@Nullable Transaction tx, Tuple key, Tuple defaultValue) {
        return (Tuple)ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    public CompletableFuture<Tuple> getOrDefaultAsync(@Nullable Transaction tx, Tuple key, Tuple defaultValue) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            Row keyRow = this.marshal(key, null, schemaVersion);
            return this.tbl.get((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(r -> (Tuple)IgniteUtils.nonNullOrElse((Object)this.unmarshalValue((BinaryRow)r, schemaVersion), (Object)defaultValue));
        });
    }

    public Map<Tuple, Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Map)ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    public CompletableFuture<Map<Tuple, Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        return this.doOperation(tx, schemaVersion -> {
            List<BinaryRowEx> keyRows = this.marshalKeys(keys, schemaVersion);
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> this.unmarshalValues((Collection<BinaryRow>)rows, schemaVersion));
        });
    }

    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return this.get(tx, key) != null;
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        return this.getAsync(tx, key).thenApply(Objects::nonNull);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.doOperation(tx, schemaVersion -> {
            List<BinaryRowEx> keyRows = this.marshalKeys(keys, schemaVersion);
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                for (BinaryRow row : rows) {
                    if (row != null) continue;
                    return false;
                }
                return true;
            });
        });
    }

    public void put(@Nullable Transaction tx, Tuple key, Tuple val) {
        ViewUtils.sync(this.putAsync(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(key, val, schemaVersion);
            return this.tbl.upsert((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public void putAll(@Nullable Transaction tx, Map<Tuple, Tuple> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<Tuple, Tuple> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        for (Map.Entry<Tuple, Tuple> entry : pairs.entrySet()) {
            Objects.requireNonNull(entry.getKey(), "key");
            Objects.requireNonNull(entry.getValue(), "val");
        }
        return this.doOperation(tx, schemaVersion -> this.tbl.upsertAll(this.marshalPairs(pairs.entrySet(), schemaVersion, null), (InternalTransaction)tx));
    }

    public Tuple getAndPut(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Tuple)ViewUtils.sync(this.getAndPutAsync(tx, key, val));
    }

    public CompletableFuture<Tuple> getAndPutAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(key, val, schemaVersion);
            return this.tbl.getAndUpsert((BinaryRowEx)row, (InternalTransaction)tx).thenApply(resultRow -> this.unmarshalValue((BinaryRow)resultRow, schemaVersion));
        });
    }

    public NullableValue<Tuple> getNullableAndPut(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndPutAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        return this.getAndPutAsync(tx, key, val).thenApply(r -> r == null ? null : NullableValue.of((Object)r));
    }

    public boolean putIfAbsent(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(key, val, schemaVersion);
            return this.tbl.insert((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public boolean remove(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(key, null, schemaVersion);
            return this.tbl.delete((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(key, val, schemaVersion);
            return this.tbl.deleteExact((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public void removeAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.removeAllAsync(tx));
    }

    public Collection<Tuple> removeAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Collection)ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name().toCanonicalForm(), new Object[0]).thenApply(r -> null);
    }

    public CompletableFuture<Collection<Tuple>> removeAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        return this.doOperation(tx, schemaVersion -> {
            List<BinaryRowEx> keyRows = this.marshalKeys(keys, schemaVersion);
            return this.tbl.deleteAll(keyRows, (InternalTransaction)tx).thenApply(rows -> this.unmarshalKeys((Collection<BinaryRow>)rows, schemaVersion));
        });
    }

    public Tuple getAndRemove(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return (Tuple)ViewUtils.sync(this.getAndRemoveAsync(tx, key));
    }

    public CompletableFuture<Tuple> getAndRemoveAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> this.tbl.getAndDelete((BinaryRowEx)this.marshal(key, null, schemaVersion), (InternalTransaction)tx).thenApply(row -> this.unmarshalValue((BinaryRow)row, schemaVersion)));
    }

    public NullableValue<Tuple> getNullableAndRemove(@Nullable Transaction tx, Tuple key) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndRemoveAsync(@Nullable Transaction tx, Tuple key) {
        return this.getAndRemoveAsync(tx, key).thenApply(r -> r == null ? null : NullableValue.of((Object)r));
    }

    public boolean replace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, Tuple key, Tuple oldVal, Tuple newVal) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(key, val, schemaVersion);
            return this.tbl.replace((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple key, Tuple oldVal, Tuple newVal) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(oldVal, "oldVal");
        Objects.requireNonNull(newVal, "newVal");
        return this.doOperation(tx, schemaVersion -> {
            Row oldRow = this.marshal(key, oldVal, schemaVersion);
            Row newRow = this.marshal(key, newVal, schemaVersion);
            return this.tbl.replace((BinaryRowEx)oldRow, (BinaryRowEx)newRow, (InternalTransaction)tx);
        });
    }

    public Tuple getAndReplace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Tuple)ViewUtils.sync(this.getAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.doOperation(tx, schemaVersion -> this.tbl.getAndReplace((BinaryRowEx)this.marshal(key, val, schemaVersion), (InternalTransaction)tx).thenApply(row -> this.unmarshalValue((BinaryRow)row, schemaVersion)));
    }

    public NullableValue<Tuple> getNullableAndReplace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndReplaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        return this.getAndReplaceAsync(tx, key, val).thenApply(r -> r == null ? null : NullableValue.of((Object)r));
    }

    private Row marshal(Tuple key, @Nullable Tuple val, int schemaVersion) {
        return this.marshallerCache.marshaller(schemaVersion).marshal(key, val);
    }

    @Nullable
    private Tuple unmarshalValue(BinaryRow row, int schemaVersion) {
        if (row == null) {
            return null;
        }
        return TableRow.valueTuple(this.rowConverter.resolveRow(row, schemaVersion));
    }

    private Map<Tuple, Tuple> unmarshalValues(Collection<BinaryRow> rows, int schemaVersion) {
        HashMap pairs = IgniteUtils.newHashMap((int)rows.size());
        for (Row row : this.rowConverter.resolveRows(rows, schemaVersion)) {
            if (row == null) continue;
            pairs.put(TableRow.keyTuple(row), TableRow.valueTuple(row));
        }
        return pairs;
    }

    private List<BinaryRowEx> marshalKeys(Collection<Tuple> keys, int schemaVersion) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(keys.size());
        for (Tuple keyRec : keys) {
            keyRows.add((BinaryRowEx)this.marshal(Objects.requireNonNull(keyRec, "keyRec"), null, schemaVersion));
        }
        return keyRows;
    }

    private Collection<Tuple> unmarshalKeys(Collection<BinaryRow> rows, int schemaVersion) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(rows.size());
        for (Row row : this.rowConverter.resolveKeys(rows, schemaVersion)) {
            tuples.add(TableRow.keyTuple(row));
        }
        return tuples;
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<Tuple, Tuple>>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher, "publisher");
        KeyValueTupleStreamerPartitionAwarenessProvider partitioner = new KeyValueTupleStreamerPartitionAwarenessProvider(this.rowConverter.registry(), this.tbl.partitions());
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.withSchemaSync(null, schemaVersion -> this.tbl.updateAll((Collection<BinaryRowEx>)this.marshalPairs(items, schemaVersion, deleted), deleted, (int)partitionId)));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, options, batchSender, partitioner, this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, Map.Entry<Tuple, Tuple>> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        KeyValueTupleStreamerPartitionAwarenessProvider partitioner = new KeyValueTupleStreamerPartitionAwarenessProvider(this.rowConverter.registry(), this.tbl.partitions());
        StreamerBatchSender batchSender = (partitionIndex, rows, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.tbl.partitionLocation((int)partitionIndex).thenCompose(node -> this.tbl.streamerReceiverRunner().runReceiverAsync(receiver, receiverArg, rows, (InternalClusterNode)node, receiver.units())));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options, batchSender, resultSubscriber, partitioner, this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    private List<BinaryRowEx> marshalPairs(Collection<Map.Entry<Tuple, Tuple>> pairs, int schemaVersion, @Nullable BitSet deleted) {
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(pairs.size());
        for (Map.Entry<Tuple, Tuple> pair : pairs) {
            boolean isDeleted = deleted != null && deleted.get(rows.size());
            Tuple key = Objects.requireNonNull(pair.getKey(), "key");
            Tuple val = isDeleted ? null : Objects.requireNonNull(pair.getValue(), "val");
            Row row = this.marshal(key, val, schemaVersion);
            rows.add((BinaryRowEx)row);
        }
        return rows;
    }

    @Override
    protected Function<SqlRow, Map.Entry<Tuple, Tuple>> queryMapper(ResultSetMetadata meta, SchemaDescriptor schema) {
        return row -> new IgniteBiTuple((Object)new SqlRowProjection(row, meta, KeyValueBinaryViewImpl.columnNames(schema.keyColumns())), (Object)new SqlRowProjection(row, meta, KeyValueBinaryViewImpl.columnNames(schema.valueColumns())));
    }
}

