/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.util.concurrent.CompletableFuture;

class TxRwOperationCounter {
    private final long operationCount;
    private final CompletableFuture<Void> completeOperationFuture;

    private TxRwOperationCounter(long operationCount, CompletableFuture<Void> completeOperationFuture) {
        this.operationCount = operationCount;
        this.completeOperationFuture = completeOperationFuture;
    }

    static TxRwOperationCounter withCountOne() {
        return new TxRwOperationCounter(1L, new CompletableFuture<Void>());
    }

    TxRwOperationCounter incrementOperationCount() {
        assert (this.operationCount > 0L) : this.operationCount;
        return new TxRwOperationCounter(this.operationCount + 1L, this.completeOperationFuture);
    }

    TxRwOperationCounter decrementOperationCount() {
        assert (this.operationCount > 0L) : this.operationCount;
        return new TxRwOperationCounter(this.operationCount - 1L, this.completeOperationFuture);
    }

    boolean isOperationsOver() {
        return this.operationCount == 0L;
    }

    CompletableFuture<Void> operationsFuture() {
        return this.completeOperationFuture;
    }
}

