/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelNodes {
    public static final Comparator<RelNode> COMPARATOR = new RelNodeComparator();
    public static final Ordering<RelNode> ORDERING = Ordering.from(COMPARATOR);

    private RelNodes() {
    }

    public static int compareRels(RelNode[] rels0, RelNode[] rels1) {
        int c = Integer.compare(rels0.length, rels1.length);
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < rels0.length; ++i) {
            c = COMPARATOR.compare(rels0[i], rels1[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public static boolean contains(RelNode rel, Predicate<AggregateCall> aggPredicate, RexUtil.RexFinder finder) {
        try {
            RelNodes.findRex(rel, finder, aggPredicate, (relNode, rexNode) -> {
                throw Util.FoundOne.NULL;
            });
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static void findRex(RelNode rel, RexUtil.RexFinder finder, Predicate<AggregateCall> aggPredicate, BiConsumer<RelNode, @Nullable RexNode> consumer) {
        if (rel instanceof Filter) {
            Filter filter = (Filter)rel;
            try {
                filter.getCondition().accept(finder);
            }
            catch (Util.FoundOne e) {
                consumer.accept(filter, (RexNode)e.getNode());
            }
        }
        if (rel instanceof Project) {
            Project project = (Project)rel;
            for (RexNode node : project.getProjects()) {
                try {
                    node.accept(finder);
                }
                catch (Util.FoundOne e) {
                    consumer.accept(project, (RexNode)e.getNode());
                }
            }
        }
        if (rel instanceof Join) {
            Join join = (Join)rel;
            try {
                join.getCondition().accept(finder);
            }
            catch (Util.FoundOne e) {
                consumer.accept(join, (RexNode)e.getNode());
            }
        }
        if (rel instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)rel;
            for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                if (!aggPredicate.test(aggregateCall)) continue;
                consumer.accept(aggregate, null);
            }
        }
        for (RelNode input : rel.getInputs()) {
            RelNodes.findRex(input, finder, aggPredicate, consumer);
        }
    }

    private static class RelNodeComparator
    implements Comparator<RelNode> {
        private RelNodeComparator() {
        }

        @Override
        public int compare(RelNode o1, RelNode o2) {
            int c = Integer.compare(o1.getRowType().getFieldCount(), o2.getRowType().getFieldCount());
            if (c != 0) {
                return -c;
            }
            return Integer.compare(o1.getId(), o2.getId());
        }
    }
}

